<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-02 19:16:56
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Reviewer
 */
class Reviewer {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Reviewer";

    /**
     * 进入审核人队列
     * @return  mixed
    */
    public static function joinReviewQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinReviewQueue();
    }
    /**
     * 退出审核人队列
     * @return  mixed
    */
    public static function exitReviewQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitReviewQueue();
    }
    /**
     * 获取审核队列信息
     * @return  mixed
    */
    public static function getReviewQueueInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReviewQueueInfo();
    }
    /**
     * 获取今日审核工作统计
     * @return  mixed
    */
    public static function getTodayReviewQuota () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayReviewQuota();
    }
    /**
     * 获取审核信息
     * @return  mixed
    */
    public static function getReviewInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReviewInfo();
    }
    /**
     * 审核通过
     * @return  mixed
    */
    public static function passStream (int $streamId, array $photoData = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passStream(["streamId" => $streamId, "photoData" => $photoData]);
    }
    /**
     * 审核退单
     * @return  mixed
    */
    public static function refuseStream (int $streamId, array $photoData, string $reviewNote = '', bool $isUntied = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuseStream(["streamId" => $streamId, "photoData" => $photoData, "reviewNote" => $reviewNote, "isUntied" => $isUntied]);
    }
    /**
     * Ai自动化-获取配置列表
     * @return  mixed
    */
    public static function getAiAutoScoreConfigs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAiAutoScoreConfigs();
    }
    /**
     * Ai自动化-审核通过
     * @return  bool
    */
    public static function aiAutoPassStream (int $streamId, array $photoTags = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->aiAutoPassStream(["streamId" => $streamId, "photoTags" => $photoTags]);
    }
    /**
     * Ai自动化-审核退单
     * @return  bool
    */
    public static function aiAutoRefuseStream (int $streamId, array $photoTags, bool $isUntied = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->aiAutoRefuseStream(["streamId" => $streamId, "photoTags" => $photoTags, "isUntied" => $isUntied]);
    }
    /**
     * 结算-沙漏额外收益
     * @return  mixed
    */
    public static function balanceHourglassExtraIncome (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceHourglassExtraIncome(["id" => $id]);
    }
    /**
     * 结算-冲量额外收益
     * @return  mixed
    */
    public static function balanceImpulseExtraIncome (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceImpulseExtraIncome(["id" => $id]);
    }
    /**
     * 结算-时段奖励
     * @return  mixed
    */
    public static function balanceTimeIntervalReward (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balanceTimeIntervalReward(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}