<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method dealStaffByParams(array $params)
 * @method getStaffWithGroupByIdByParams(array $params)
 * @method getStaffStateByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步禁用
     *
     * @param  int $staff_id 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dealStaff (int $staff_id) {
        return self::getClass()->dealStaff([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取修图师信息
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWithGroupById (int $staffId) {
        return self::getClass()->getStaffWithGroupById([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取所有启用修图师状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffState () {
        return self::getClass()->getStaffState();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}