<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method batchGetOrderInfoByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getOrderInfoInnerByParams(array $params)
 * @method closeOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @support  string $storeName 门店名称 [ require false ]
     * @support  int $storeId 门店id[tag] [ require false ]
     * @support  string $photographer 摄影师 [ require false ]
     * @support  string $dresser 化妆师 [ require false ]
     * @support  string $customerName 顾客姓名 [ require false ]
     * @support  string $telephone 顾客电话 [ require false ]
     * @support  string $dresserNote 化妆师备注 [ require false ]
     * @support  string $orderNote 订单备注 [ require false ]
     * @support  string $showPicFrom 修修兽订单来源 [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder (string $externalNum) {
        return self::getClass()->createOrder([
            "externalNum" => $externalNum,
        ]);
    }

    /**
     * 批量获取订单信息
     *
     * @param  array $externalNums 外部订单号 [ require true ]
     * @param  int $needPhoto 是否需要照片信息 [ require false ]
     * @param  bool $withDeletedStream 是否需要被删除的流水 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetOrderInfo (array $externalNums, int $needPhoto = 0, bool $withDeletedStream = true) {
        return self::getClass()->batchGetOrderInfo([
            "externalNums" => $externalNums,
            "needPhoto" => $needPhoto,
            "withDeletedStream" => $withDeletedStream,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @param  bool $withDeletedStream 是否需要被删除的流水 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfo (string $externalNum, bool $withDeletedStream = true) {
        return self::getClass()->getOrderInfo([
            "externalNum" => $externalNum,
            "withDeletedStream" => $withDeletedStream,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @param  bool $withDeletedStream 是否需要被删除的流水 [ require true ]
     * @param  int $orgId 摄影机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfoInner (int $orgId, string $externalNum, bool $withDeletedStream = true) {
        return self::getClass()->getOrderInfoInner([
            "orgId" => $orgId,
            "externalNum" => $externalNum,
            "withDeletedStream" => $withDeletedStream,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (string $externalNum) {
        return self::getClass()->closeOrder([
            "externalNum" => $externalNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}