<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getGoalRewardProductsByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $params)
 * @method getGoalRewardListByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardListCMD $params)
 * @method addGoalRewardConfigByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\AddGoalRewardConfigCMD $params)
 * @method editGoalRewardConfigByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\EditGoalRewardConfigCMD $params)
 */
class GoalRewardConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 超修奖励配置 - 可选产品列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $goalRewardProductCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardProductDTO[]
     */
    public static function getGoalRewardProducts (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $goalRewardProductCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGoalRewardProducts($goalRewardProductCmd),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardProductDTO[]"
        );
    }


    /**
     * 超修奖励配置 - 可选产品列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardListCMD $goalRewardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardListPageDTO
     */
    public static function getGoalRewardList (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardListCMD $goalRewardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGoalRewardList($goalRewardListCmd),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardListPageDTO"
        );
    }


    /**
     * 新增超修奖励配置
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\AddGoalRewardConfigCMD $addRewardConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function addGoalRewardConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\AddGoalRewardConfigCMD $addRewardConfigCmd) {
        return self::getClass()->addGoalRewardConfig($addRewardConfigCmd);
    }


    /**
     * 修改超修奖励配置
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\EditGoalRewardConfigCMD $editGoalRewardConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editGoalRewardConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\EditGoalRewardConfigCMD $editGoalRewardConfigCmd) {
        return self::getClass()->editGoalRewardConfig($editGoalRewardConfigCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'GoalRewardConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'GoalRewardConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}