<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLearnPlanListByParams(array $params)
 * @method getLearnPlanTotalByParams(array $params)
 * @method getLearnPlanPlanDetailByParams(array $params)
 * @method urgedCompleteByParams(array $params)
 * @method urgedMarkingByParams(array $params)
 * @method learningPlanMarkPaperByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\MarkPaper\MarkPaper $params)
 * @method getPaperDetailByParams(array $params)
 * @method startPaperByParams(array $params)
 * @method startLearningPlanExamByParams(array $params)
 * @method submitLearningPlanPaperByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\SubmitLearningPlanPaper\SubmitLearningPlanPaper $params)
 * @method learningPlanStartByParams(array $params)
 * @method learningStateExportByPlanIdByParams(array $params)
 */
class LearnPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学习列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @support  int $trainingPlanId 培训计划id [ require true ]
     * @support  array $mentorIds 导师ids [ require false ]
     * @support  array $stateIn 学习状态 [ require false ]
     * @support  bool $onlyMarkingToMe 仅查看需要我阅卷考核 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanList () {
        return self::getClass()->getLearnPlanList([
        ]);
    }

    /**
     * 学习计划人数
     *
     * @param  int $trainingPlanId 培训计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanTotal (int $trainingPlanId) {
        return self::getClass()->getLearnPlanTotal([
            "trainingPlanId" => $trainingPlanId,
        ]);
    }

    /**
     * 学习计划详情
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanPlanDetail (int $learningPlanId) {
        return self::getClass()->getLearnPlanPlanDetail([
            "learningPlanId" => $learningPlanId,
        ]);
    }

    /**
     * 催促完成
     *
     * @param  int $planId 配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function urgedComplete (int $planId) {
        return self::getClass()->urgedComplete([
            "planId" => $planId,
        ]);
    }

    /**
     * 催促阅卷
     *
     * @param  int $planId 配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function urgedMarking (int $planId) {
        return self::getClass()->urgedMarking([
            "planId" => $planId,
        ]);
    }

    /**
     * 阅卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\MarkPaper\MarkPaper $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function learningPlanMarkPaper (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\MarkPaper\MarkPaper $params) {
        return self::getClass()->learningPlanMarkPaper($params);
    }


    /**
     * 获取考核记录与试卷
     *
     * @param  string $paperId 试卷id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaperDetail (string $paperId) {
        return self::getClass()->getPaperDetail([
            "paperId" => $paperId,
        ]);
    }

    /**
     * 开始一张试卷
     *
     * @param  string $paperId 试卷id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startPaper (string $paperId) {
        return self::getClass()->startPaper([
            "paperId" => $paperId,
        ]);
    }

    /**
     * 开始学习计划考核
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startLearningPlanExam (int $learningPlanId) {
        return self::getClass()->startLearningPlanExam([
            "learningPlanId" => $learningPlanId,
        ]);
    }

    /**
     * 学习计划提交试卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\SubmitLearningPlanPaper\SubmitLearningPlanPaper $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitLearningPlanPaper (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\SubmitLearningPlanPaper\SubmitLearningPlanPaper $params) {
        return self::getClass()->submitLearningPlanPaper($params);
    }


    /**
     * 开始学习计划
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function learningPlanStart (int $learningPlanId) {
        return self::getClass()->learningPlanStart([
            "learningPlanId" => $learningPlanId,
        ]);
    }

    /**
     * 根据计划id导出伙伴培训状态
     *
     * @support  int $trainingPlanId 培训计划id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function learningStateExportByPlanId () {
        return self::getClass()->learningStateExportByPlanId([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}