<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getGoalRewardProductsByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $params)
 */
class GoalRewardConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 超修奖励配置 - 可选产品列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $goalRewardProductCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getGoalRewardProducts (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $goalRewardProductCmd) {
        return self::getClass()->getGoalRewardProducts($goalRewardProductCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'GoalRewardConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'GoalRewardConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}