<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getByParams(array $params)
 * @method onByParams(array $params)
 * @method offByParams(array $params)
 * @method settingByParams(array $params)
 * @method registerByParams(array $params)
 */
class TriggerSetting {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据开关名称获取开关配置
     *
     * @param  string $name 开关名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function get (string $name) {
        return self::getClass()->get([
            "name" => $name,
        ]);
    }

    /**
     * 开启开关
     *
     * @param  string $name 开关名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function on (string $name) {
        return self::getClass()->on([
            "name" => $name,
        ]);
    }

    /**
     * 关闭开关
     *
     * @param  string $name 开关名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function off (string $name) {
        return self::getClass()->off([
            "name" => $name,
        ]);
    }

    /**
     * 开关配置修改
     *
     * @param  string $name 开关名称 [ require true ]
     * @param  array $setting  [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setting (string $name, array $setting) {
        return self::getClass()->setting([
            "name" => $name,
            "setting" => $setting,
        ]);
    }

    /**
     * 开关配置修改
     *
     * @param  string $name 开关名称 [ require true ]
     * @param  array $setting 配置内容 [ require true ]
     * @param  bool $state 默认状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function register (string $name, array $setting, bool $state = true) {
        return self::getClass()->register([
            "name" => $name,
            "setting" => $setting,
            "state" => $state,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'TriggerSetting');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'TriggerSetting');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}