<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Proudct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchAddProductAISettingByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Product\BatchAddProductAISetting $params)
 */
class ProductAISetting {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * batchAddProductAISetting
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Product\BatchAddProductAISetting $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAddProductAISetting (\Mainto\Bridge\Structs\ProjectCloud\Objects\Product\BatchAddProductAISetting $cmd) {
        return self::getClass()->batchAddProductAISetting($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Proudct\ProductAISetting');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Proudct\ProductAISetting');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}