<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method fixApiSubmitStreamByParams(array $params)
 * @method getQueueLengthByParams(array $params)
 * @method clearFinishPhotoByParams(array $params)
 * @method fixXiuDataByParams(array $params)
 * @method fixReworkReplaceByParams(array $params)
 * @method clearRetoucherLeaderLittleBeeCacheByParams(array $params)
 * @method rePushReviewStreamQueueByParams(array $params)
 * @method pushRetouchQueueByParams(array $params)
 * @method fix2QueueByParams(array $params)
 * @method pushReviewQueueByParams(array $params)
 * @method autoSendRetoucherLeaderAppealExamineByParams(array $params)
 * @method autoSendAppealManagerExamineByParams(array $params)
 * @method forcePassTestByParams(array $params)
 * @method clearProductCategoryTreeCacheByParams(array $params)
 * @method checkStaffLevelByParams(array $params)
 * @method clearStaffLevelInfoCacheByParams(array $params)
 * @method sendKpiSetMessageByParams(array $params)
 * @method sendWaitRetouchPhotoCountByParams(array $params)
 * @method batchJoinRetouchQueueByParams(array $params)
 * @method addPassProductsByParams(array $params)
 * @method batchDisableStaffByParams(array $params)
 * @method batchEnableStaffByParams(array $params)
 * @method releaseStreamToQueueByParams(array $params)
 * @method clearStaffTagByParams(array $params)
 * @method calcWeeklyQualityReportsByParams(array $params)
 */
class Temple {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * fix3Rd提交一已修流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @param  int $retouchOrgId orgId [ require true ]
     * @param  bool $needCheckPool 是否需要云学院处理 [ require false ]
     * @param  bool $needReview 是否需要审核 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function fixApiSubmitStream (int $retouchOrgId, string $streamNum, array $photoData, bool $needCheckPool = false, bool $needReview = false) {
        return self::getClass()->fixApiSubmitStream([
            "retouchOrgId" => $retouchOrgId,
            "streamNum" => $streamNum,
            "photoData" => $photoData,
            "needCheckPool" => $needCheckPool,
            "needReview" => $needReview,
        ]);
    }

    /**
     * 【大数据使用】
     *
     * @param  string $queueName 队列名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueLength (string $queueName) {
        return self::getClass()->getQueueLength([
            "queueName" => $queueName,
        ]);
    }

    /**
     * 清空流水－顾客满意片[test]
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearFinishPhoto (string $streamNum) {
        return self::getClass()->clearFinishPhoto([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 补发流水已完成事件
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixXiuData (string $streamNum) {
        return self::getClass()->fixXiuData([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 补发流水已完成事件
     *
     * @param  array $photoIds 退回新照片 [ require true ]
     * @param  int $newStreamId 退回新流水 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixReworkReplace (array $photoIds, int $newStreamId) {
        return self::getClass()->fixReworkReplace([
            "photoIds" => $photoIds,
            "newStreamId" => $newStreamId,
        ]);
    }

    /**
     * 清除修图主管小蜜蜂缓存
     *
     * @param  int $year 年份 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearRetoucherLeaderLittleBeeCache (int $year = null) {
        return self::getClass()->clearRetoucherLeaderLittleBeeCache([
            "year" => $year,
        ]);
    }

    /**
     * 重推审核队列[清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rePushReviewStreamQueue () {
        return self::getClass()->rePushReviewStreamQueue();
    }

    /**
     * 重推接单队列[不清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushRetouchQueue () {
        return self::getClass()->pushRetouchQueue();
    }

    /**
     * 修复队列未清单问题
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fix2Queue () {
        return self::getClass()->fix2Queue();
    }

    /**
     * 重推审核队列[不清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushReviewQueue () {
        return self::getClass()->pushReviewQueue();
    }

    /**
     * 主动触发-自动发送修图主管待初审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendRetoucherLeaderAppealExamine () {
        return self::getClass()->autoSendRetoucherLeaderAppealExamine();
    }

    /**
     * 主动触发-自动发送修图主管待初审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendAppealManagerExamine () {
        return self::getClass()->autoSendAppealManagerExamine();
    }

    /**
     * 强制接单-提交-审核通过
     *
     * @param  int $staffId 指定人 [ require true ]
     * @param  string $streamNum 指定流水num [ require true ]
     * @param  array $deals 处理组[&#039;bind&#039;, &#039;submit&#039;, &#039;pass&#039;], 默认全部 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forcePassTest (int $staffId, string $streamNum, array $deals = [0 => 'bind',1 => 'submit',2 => 'pass']) {
        return self::getClass()->forcePassTest([
            "staffId" => $staffId,
            "streamNum" => $streamNum,
            "deals" => $deals,
        ]);
    }

    /**
     * clearProductCategoryTreeCache
     *
     * @param  int $rootId 根节点id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearProductCategoryTreeCache (int $rootId) {
        return self::getClass()->clearProductCategoryTreeCache([
            "rootId" => $rootId,
        ]);
    }

    /**
     * 触发员工升降级检查
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkStaffLevel (int $staffId) {
        return self::getClass()->checkStaffLevel([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 清空员工升级信息缓存
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearStaffLevelInfoCache (int $staffId) {
        return self::getClass()->clearStaffLevelInfoCache([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 绩效导入截止日期通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKpiSetMessage () {
        return self::getClass()->sendKpiSetMessage();
    }

    /**
     * 推送待修图照片张数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWaitRetouchPhotoCount () {
        return self::getClass()->sendWaitRetouchPhotoCount();
    }

    /**
     * 批量推送人员进修图队列
     *
     * @param  array $retoucherIds retoucherIds [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchJoinRetouchQueue (array $retoucherIds = []) {
        return self::getClass()->batchJoinRetouchQueue([
            "retoucherIds" => $retoucherIds,
        ]);
    }

    /**
     * 暂停产品移到通关产品
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  array $productIds 产品ids [ require false ]
     * @param  int $retouchClassId 修图类别id [ require false ]
     * @param  string $type del:删除，add:添加 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addPassProducts (int $staffId, string $type = 'add', array $productIds = null, int $retouchClassId = null) {
        return self::getClass()->addPassProducts([
            "staffId" => $staffId,
            "type" => $type,
            "productIds" => $productIds,
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * 批量禁用员工
     *
     * @param  array $staffIds 员工ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDisableStaff (array $staffIds) {
        return self::getClass()->batchDisableStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量恢复员工
     *
     * @param  array $staffIds 员工ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchEnableStaff (array $staffIds) {
        return self::getClass()->batchEnableStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 重推被接试修流水到队列
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function releaseStreamToQueue (string $streamNum) {
        return self::getClass()->releaseStreamToQueue([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 清除员工标记, 刷新缓存
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearStaffTag (int $staffId) {
        return self::getClass()->clearStaffTag([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 手动刷新排行榜数据
     *
     * @support  string $startTime 统计开始时间 [ require false ]
     * @support  string $endTime 统计结束时间 [ require false ]
     * @support  array $types 榜单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function calcWeeklyQualityReports () {
        return self::getClass()->calcWeeklyQualityReports([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Temple');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Temple');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}