<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSignatureByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method getHostByParams(array $params)
 * @method createPhotoVersionByParams(array $params)
 * @method checkUploadIntranetPhotoByParams(array $params)
 * @method uploadIntranetPhotosByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\UploadIntranetPhotos $params)
 */
class PhotoManager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云上传凭证
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSignature () {
        return self::getClass()->getSignature();
    }

    /**
     * 获取七牛云上传token
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 返回host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 覆盖上传
     *
     * @param  string $version 照片版本 [ require true ]
     * @param  string $path 照片路径 [ require true ]
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhotoVersion (string $version, string $path, int $photoId) {
        return self::getClass()->createPhotoVersion([
            "version" => $version,
            "path" => $path,
            "photoId" => $photoId,
        ]);
    }

    /**
     * 检查本地上传服务是否可用
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkUploadIntranetPhoto () {
        return self::getClass()->checkUploadIntranetPhoto();
    }

    /**
     * 本地上传照片记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\UploadIntranetPhotos $uploadIntranetPhotos
     * @throws  \Exception
     * @return  bool
     */
    public static function uploadIntranetPhotos (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\UploadIntranetPhotos $uploadIntranetPhotos) {
        return self::getClass()->uploadIntranetPhotos($uploadIntranetPhotos);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}