<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitFinalFilmByParams(array $params)
 * @method clearFinishPhotoByParams(array $params)
 * @method batchGetPhotoInfoByIdByParams(array $params)
 * @method batchGetPhotoInfoByIdsByParams(array $params)
 * @method firstPhotoInfoByIdByParams(array $params)
 * @method batchPhotosAndPagesByParams(array $params)
 * @method batchGetFinishPhotosByOrderNumByParams(array $params)
 * @method addOnlineUpdatePhotoVersionByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交最终成片[看片完成]
     *
     * @param  array $versionData 成片信息 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @support  bool $part 是否开启部分提交 [ require false ]
     * @param  bool $isClear 是否清空流水顾客满意片 [ require false ]
     * @param  bool $isFinish 是否为最终成片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalFilm (array $versionData, string $streamNum, bool $isClear = false, bool $isFinish = true) {
        return self::getClass()->submitFinalFilm([
            "versionData" => $versionData,
            "streamNum" => $streamNum,
            "isClear" => $isClear,
            "isFinish" => $isFinish,
        ]);
    }

    /**
     * 清空流水－顾客满意片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearFinishPhoto (string $streamNum) {
        return self::getClass()->clearFinishPhoto([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 根据照片id批量获取照片信息
     *
     * @param  array $ids 照片id [ require true ]
     * @param  string $position 版本位置 [ require false ]
     * @param  string $version 版本名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetPhotoInfoById (array $ids, string $position = 'desc', string $version = null) {
        return self::getClass()->batchGetPhotoInfoById([
            "ids" => $ids,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 根据照片id批量获取照片信息-包含订单信息
     *
     * @param  array $ids 照片id [ require true ]
     * @param  array $versions 版本名称s [ require true ]
     * @param  string $extend 包含数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetPhotoInfoByIds (array $ids, array $versions, string $extend = 'cloud_spot_check') {
        return self::getClass()->batchGetPhotoInfoByIds([
            "ids" => $ids,
            "versions" => $versions,
            "extend" => $extend,
        ]);
    }

    /**
     * 根据id获取照片信息
     *
     * @param  int $id 照片id [ require true ]
     * @param  string $position 获取当前版本的第一个或者最后一个 [ require true ]
     * @param  string $version 照片版本 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstPhotoInfoById (int $id, string $position, string $version = null) {
        return self::getClass()->firstPhotoInfoById([
            "id" => $id,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 批量获取订单照片信息-支持分页
     *
     * @support  array $externalNums 外部订单号s [ require true ]
     * @support  array $photoIds 照片ids [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchPhotosAndPages (int $page = 1, int $pageSize = 10) {
        return self::getClass()->batchPhotosAndPages([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 批量获取最终成片
     *
     * @param  array $externalNums 外部订单号s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetFinishPhotosByOrderNum (array $externalNums) {
        return self::getClass()->batchGetFinishPhotosByOrderNum([
            "externalNums" => $externalNums,
        ]);
    }

    /**
     * 增加在线看片最后更新版本
     *
     * @param  array $photoData 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOnlineUpdatePhotoVersion (array $photoData) {
        return self::getClass()->addOnlineUpdatePhotoVersion([
            "photoData" => $photoData,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}