<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWeeklyQualityReportsByParams(array $params)
 * @method calcWeeklyQualityReportsByParams(array $params)
 * @method autoCalcWeeklyQualityReportsByParams(array $params)
 */
class WeeklyQualityReport {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排行榜接口
     *
     * @support  string $type 榜单类型 [ require false ]
     * @param  int $count 返回排名个数 [ require false ]
     * @support  string $startTime 统计开始时间 [ require false ]
     * @support  string $endTime 统计结束时间 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWeeklyQualityReports (int $count = 10) {
        return self::getClass()->getWeeklyQualityReports([
            "count" => $count,
        ]);
    }

    /**
     * 手动刷新统计数据
     *
     * @support  string $startTime 统计开始时间 [ require false ]
     * @support  string $endTime 统计结束时间 [ require false ]
     * @support  array $types 榜单类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function calcWeeklyQualityReports () {
        return self::getClass()->calcWeeklyQualityReports([
        ]);
    }

    /**
     * 自动统计排行榜数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoCalcWeeklyQualityReports () {
        return self::getClass()->autoCalcWeeklyQualityReports();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'WeeklyQualityReport');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'WeeklyQualityReport');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}