<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createHimoNpsByParams(array $params)
 * @method outStreamWaitReviewByParams(array $params)
 * @method outStreamWaitReviewedByParams(array $params)
 * @method staffPositionUpdateByParams(array $params)
 * @method hookQuotaEventByParams(array $params)
 * @method hookRefreshQueueSyncByParams(array $params)
 * @method hookStaffPassProductsByParams(array $params)
 * @method hookDelayReviewPassByParams(array $params)
 * @method hookPassConfigNotifyByParams(array $params)
 * @method hookLearningPlanExamFailByParams(array $params)
 * @method hookOnlineWatcherTakeOrderByParams(array $params)
 * @method hookWatchRecordFinishByParams(array $params)
 * @method hookWatchRecordCloseByParams(array $params)
 * @method hookWatchRecordConfirmByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听创建NPS记录
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  float $retoucherScore 修片师分数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createHimoNps (string $orderNo, float $retoucherScore) {
        return self::getClass()->createHimoNps([
            "orderNo" => $orderNo,
            "retoucherScore" => $retoucherScore,
        ]);
    }

    /**
     * 监听外包审核状态-等待审核
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReview (string $streamId) {
        return self::getClass()->outStreamWaitReview([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 监听外包审核状态-审核中
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReviewed (string $streamId) {
        return self::getClass()->outStreamWaitReviewed([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 监听岗位变动
     *
     * @param  int $staffId staffId [ require true ]
     * @param  int $originalPositionId 原岗位id [ require true ]
     * @param  int $positionId 变更后岗位id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffPositionUpdate (int $staffId, int $originalPositionId, int $positionId) {
        return self::getClass()->staffPositionUpdate([
            "staffId" => $staffId,
            "originalPositionId" => $originalPositionId,
            "positionId" => $positionId,
        ]);
    }

    /**
     * 监听指标变动
     *
     * @support  string $item_name item_name [ require true ]
     * @support  int $object_id object_id [ require true ]
     * @support  string $type type [ require true ]
     * @support  int $cycle cycle [ require true ]
     * @support  float $value value [ require true ]
     * @support  string $event event [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookQuotaEvent () {
        return self::getClass()->hookQuotaEvent([
        ]);
    }

    /**
     * 异步刷新队列权重-延迟队列
     *
     * @support  int $id 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookRefreshQueueSync () {
        return self::getClass()->hookRefreshQueueSync([
        ]);
    }

    /**
     * 伙伴通关卡
     *
     * @param  int $staffId 通关伙伴 [ require true ]
     * @param  int $trainingPlanId 计划id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStaffPassProducts (int $staffId, int $trainingPlanId) {
        return self::getClass()->hookStaffPassProducts([
            "staffId" => $staffId,
            "trainingPlanId" => $trainingPlanId,
        ]);
    }

    /**
     * 延迟审核
     *
     * @param  int $streamId 流水id [ require true ]
     * @param  int $reviewId 审核人id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookDelayReviewPass (int $streamId, int $reviewId) {
        return self::getClass()->hookDelayReviewPass([
            "streamId" => $streamId,
            "reviewId" => $reviewId,
        ]);
    }

    /**
     * 监听星耀培训创建完成
     *
     * @param  int $planId 计划id [ require true ]
     * @param  array $retoucherIds 培训伙伴ids [ require false ]
     * @support  array $markingMentorIds 阅卷导师ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPassConfigNotify (int $planId, array $retoucherIds = []) {
        return self::getClass()->hookPassConfigNotify([
            "planId" => $planId,
            "retoucherIds" => $retoucherIds,
        ]);
    }

    /**
     * 监听星耀培训营重考通知
     *
     * @param  int $trainingPlanId 计划id [ require true ]
     * @param  int $staffId 重考伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookLearningPlanExamFail (int $trainingPlanId, int $staffId) {
        return self::getClass()->hookLearningPlanExamFail([
            "trainingPlanId" => $trainingPlanId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 监听在线看片被接单
     *
     * @param  int $outsideNo 外部订单号 [ require true ]
     * @param  int $watcherId 看片师id [ require true ]
     * @param  int $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOnlineWatcherTakeOrder (int $outsideNo, int $watcherId, int $recordNo) {
        return self::getClass()->hookOnlineWatcherTakeOrder([
            "outsideNo" => $outsideNo,
            "watcherId" => $watcherId,
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 监听在线看片完成
     *
     * @param  int $outsideNo 外部订单号 [ require true ]
     * @param  array $photos 照片数据 [ require true ]
     * @param  int $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWatchRecordFinish (int $outsideNo, int $recordNo, array $photos) {
        return self::getClass()->hookWatchRecordFinish([
            "outsideNo" => $outsideNo,
            "recordNo" => $recordNo,
            "photos" => $photos,
        ]);
    }

    /**
     * 监听在线看片单关闭
     *
     * @param  int $outsideNo 外部订单号 [ require true ]
     * @param  array $photos 照片数据 [ require true ]
     * @param  int $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWatchRecordClose (int $outsideNo, int $recordNo, array $photos) {
        return self::getClass()->hookWatchRecordClose([
            "outsideNo" => $outsideNo,
            "recordNo" => $recordNo,
            "photos" => $photos,
        ]);
    }

    /**
     * 监听看片师确认在线看片单
     *
     * @param  array $streamNote 修图备注数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWatchRecordConfirm (array $streamNote) {
        return self::getClass()->hookWatchRecordConfirm([
            "streamNote" => $streamNote,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}