<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method examineFirstByParams(array $params)
 * @method examineSecondByParams(array $params)
 * @method bindFirstByParams(array $params)
 * @method bindSecondByParams(array $params)
 */
class Appeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉-v2.12
     *
     * @support  int $streamId 流水ID [ require true ]
     * @support  string $type 申诉类型 in:rework,evaluate,timeout [ require true ]
     * @support  string $desc 申诉类型 in:rework,evaluate,timeout [ require false ]
     * @support  array $photoAppeals 照片申诉数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 申诉列表-v2.12
     *
     * @support  mixed $cond  [ require false ]
     * @support  array $cond 查询条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 申诉详情-v2.12
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 初审-v2.12
     *
     * @param  int $id id [ require true ]
     * @support  array $photoExamines 审批数据 [ require false ]
     * @support  string $result 审批数据 [ require false ]
     * @support  string $reason 审核拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineFirst (int $id) {
        return self::getClass()->examineFirst([
            "id" => $id,
        ]);
    }

    /**
     * 复审-v2.12
     *
     * @param  int $id id [ require true ]
     * @support  array $photoExamines 审批数据 [ require false ]
     * @support  string $result 审批数据 [ require false ]
     * @support  string $reason 审核拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineSecond (int $id) {
        return self::getClass()->examineSecond([
            "id" => $id,
        ]);
    }

    /**
     * 初审绑定-v2.12
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFirst (int $id) {
        return self::getClass()->bindFirst([
            "id" => $id,
        ]);
    }

    /**
     * 复审绑定-v2.12
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecond (int $id) {
        return self::getClass()->bindSecond([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Appeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Appeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}