<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoListByParams(array $params)
 * @method getPhotoInfoByParams(array $params)
 * @method submitAttitudeByParams(array $params)
 * @method getAttitudePhotoInfoByParams(array $params)
 * @method getAttitudePhotoListByParams(array $params)
 * @method getPhotoStreamInfoByParams(array $params)
 * @method getSimilarPhotoListByParams(array $params)
 */
class PhotoPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取客片列表
     *
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  array $staffIds 伙伴id [Original type array&lt;uint&gt;] 
     * @support  string $streamNum 云图流水号 
     * @support  string $orderNum 订单号 
     * @support  string $customerName 顾客姓名 
     * @support  string $telephone 手机号 
     * @support  string $photoVersion 照片版本 
     * @support  array $productIds 产品Ids 
     * @support  array $retouchStandards 修片标准 
     * @support  int $evaluateStar 评价星级 [Original type uint] 
     * @param  int $page 页面 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPhotoList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取客片详情
     *
     * @param  string $photoUuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoInfo (string $photoUuid) {
        return self::getClass()->getPhotoInfo([
            "photoUuid" => $photoUuid,
        ]);
    }

    /**
     * 提交【踩/赞】
     *
     * @param  int $photoId 图片版本id [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitAttitude (int $photoId, string $attitude) {
        return self::getClass()->submitAttitude([
            "photoId" => $photoId,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 获取赞或踩客片详情
     *
     * @param  string $photoUuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAttitudePhotoInfo (string $photoUuid) {
        return self::getClass()->getAttitudePhotoInfo([
            "photoUuid" => $photoUuid,
        ]);
    }

    /**
     * 获取优秀/问题客片列表
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @support  array $staffIds 伙伴id [Original type array&lt;uint&gt;] 
     * @support  array $productId 产品ID [Original type array&lt;uint&gt;] 
     * @support  string $retouchStandard 修片标准 
     * @param  int $page 页面 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAttitudePhotoList (string $startAt, string $endAt, string $attitude, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAttitudePhotoList([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "attitude" => $attitude,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取照片流水与照片信息
     *
     * @param  string $imagePath 照片path [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoStreamInfo (string $imagePath) {
        return self::getClass()->getPhotoStreamInfo([
            "imagePath" => $imagePath,
        ]);
    }

    /**
     * 获取相似照片列表
     *
     * @param  string $imageKey 图片路径 [ require true ]
     * @param  int $top 取出照片数，前XX张，默认为5 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSimilarPhotoList (string $imageKey, int $top = 5) {
        return self::getClass()->getSimilarPhotoList([
            "imageKey" => $imageKey,
            "top" => $top,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}