<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method retouchByParams(array $params)
 * @method pictureOnlineByParams(array $params)
 * @method productCheckByParams(array $params)
 */
class WorkTool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修图信息
     *
     * @param  int $streamId streamId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function retouch (int $streamId = NULL) {
        return self::getClass()->retouch([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 在线看片
     *
     * @throws  \Exception
     * @return  array
     */
    public static function pictureOnline () {
        return self::getClass()->pictureOnline();
    }

    /**
     * 产品审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function productCheck () {
        return self::getClass()->productCheck();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'WorkTool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'WorkTool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}