<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method batchGetStreamInfoByParams(array $params)
 * @method revokeStreamByParams(array $params)
 * @method evaluateStreamByParams(array $params)
 * @method storeReturnStreamByParams(array $params)
 * @method getStreamIdQueueByParams(array $params)
 * @method editRetouchClaimByParams(array $params)
 * @method urgentStreamByNumWithTypeByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建流水--2.27
     *
     * @support  string $orderNum 外部订单号 [ require true ]
     * @support  int $productId 拍摄产品云端产品id [ require true ]
     * @support  array $photography_color 拍摄底片 
     * @support  int $photography_color.id 拍摄底片id 
     * @support  string $photography_color.name 拍摄底片名称 
     * @support  string $photography_color.img_path 拍摄底片地址 
     * @support  array $retouch_color 修图底色 
     * @support  int $retouch_color.id 修图底色id 
     * @support  string $retouch_color.name 修图底色名称 
     * @support  string $retouch_color.img_path 修图底色地址 
     * @support  int $retouch_color.photography_color_id 修图底色关联id 
     * @support  int $retouch_color.back_color_id 修图底色关联id 
     * @support  array $texture_name 贴图名称 
     * @support  array $retouchClaim 修片要求 [ require true ]
     * @support  string $retouchClaim.eye 修片要求--眼睛 [ require true ]
     * @support  string $retouchClaim.face 修片要求--脸 [ require true ]
     * @support  bool $retouchClaim.pimples 修片要求--痘痘 [ require true ]
     * @support  string $retouchClaim.referenceImg 修片要求--参考图 
     * @support  string $takeTime 取片时间 
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $photographyNote 摄影备注 
     * @support  string $retouchNote 修片备注 [ require true ]
     * @support  bool $special 业务方权重 
     * @support  string $colorNote 背景颜色 
     * @support  array $extends 拓展字段 
     * @throws  \Exception
     * @return  string
     */
    public static function createStream () {
        return self::getClass()->createStream();
    }

    /**
     * 获取流水单详情
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @support  int $needPhoto 是否需要照片数据 
     * @support  bool $includeDeleted 是否查询已删除流水数据 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (string $streamNum) {
        return self::getClass()->getStreamInfo([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 批量获取流水单信息
     *
     * @param  array $streamNums 流水号 [ require true ]
     * @support  int $needPhoto 是否需要照片数据 
     * @support  int $needProduct 是否需要产品数据 
     * @support  bool $includeDeleted 是否查询已删除流水数据 
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfo (array $streamNums) {
        return self::getClass()->batchGetStreamInfo([
            "streamNums" => $streamNums,
        ]);
    }

    /**
     * 此处为假删除操作
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function revokeStream (string $streamNum) {
        return self::getClass()->revokeStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 门店评价流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @support  string $storeEvaluate 看片评价 
     * @support  string $watcherName 看片师姓名 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function evaluateStream (string $streamNum) {
        return self::getClass()->evaluateStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 门店退回流水照片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 退回类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeReturnStream (string $streamNum, array $photoData) {
        return self::getClass()->storeReturnStream([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 门店获取流水队列
     *
     * @support  array $streamNums 流水号 
     * @support  string $state 流水状态 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamIdQueue (int $page, int $pageSize) {
        return self::getClass()->getStreamIdQueue([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 修改订单修图要求--2.27
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $retouchClaim 修片要求 [ require true ]
     * @support  string $retouchClaim.eye 修片要求--眼睛 [ require true ]
     * @support  string $retouchClaim.face 修片要求--脸 [ require true ]
     * @support  bool $retouchClaim.pimples 修片要求--痘痘 [ require true ]
     * @support  string $retouchClaim.referenceImg 修片要求--参考图 
     * @param  string $retouchNote 修片备注 [ require true ]
     * @support  array $photography_color 拍摄底片 
     * @support  int $photography_color.id 拍摄底片id 
     * @support  string $photography_color.name 拍摄底片名称 
     * @support  string $photography_color.img_path 拍摄底片地址 
     * @support  array $retouch_color 修图底色 
     * @support  int $retouch_color.id 修图底色id 
     * @support  string $retouch_color.name 修图底色名称 
     * @support  string $retouch_color.img_path 修图底色地址 
     * @support  int $retouch_color.photography_color_id 修图底色关联id 
     * @support  int $retouch_color.back_color_id 修图底色关联id 
     * @support  array $texture_name 贴图名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetouchClaim (string $streamNum, array $retouchClaim, string $retouchNote = '') {
        return self::getClass()->editRetouchClaim([
            "streamNum" => $streamNum,
            "retouchClaim" => $retouchClaim,
            "retouchNote" => $retouchNote,
        ]);
    }

    /**
     * api加急流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  string $type 加急类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentStreamByNumWithType (string $streamNum, string $type) {
        return self::getClass()->urgentStreamByNumWithType([
            "streamNum" => $streamNum,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}