<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takeItemByParams(array $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultByParams(array $params)
 * @method getSearchHistoryByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method getStatisticsByParams(array $params)
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method getCloudScoreByGroupByParams(array $params)
 * @method getCloudProblemByGroupByParams(array $params)
 * @method updateCommitHistoryByParams(array $params)
 * @method getUpdateCommitHistoryLogByParams(array $params)
 * @method getOldScoreConfigListByParams(array $params)
 * @method emptyCheckPoolByStaffIdByParams(array $params)
 */
class ShowPicPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽抽片
     *
     * @support  int $takeNum 抽取数量 [ require true ]
     * @support  string $submitStartAt 提交开始时间 [ require false ]
     * @support  string $submitEndAt 提交结束时间 [ require false ]
     * @support  array $productIds 产品id [ require false ]
     * @support  bool $isOut 外包抽片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeItem () {
        return self::getClass()->takeItem([
        ]);
    }

    /**
     * 获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * 获取抽片结果--2.27
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  int $skip 跳过数量 [ require false ]
     * @param  int $limit 获取数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSpotCheckResult (string $uuid, int $skip = 0, int $limit = 10) {
        return self::getClass()->getSpotCheckResult([
            "uuid" => $uuid,
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * 获取抽片历史记录--2.27
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  array $retoucherIds 修图师id [ require false ]
     * @support  array $operatorIds 评分人id [ require false ]
     * @support  int $maxScore 问题标签 [ require false ]
     * @support  int $minScore 问题标签 [ require false ]
     * @support  array $tagIds 问题标签 [ require false ]
     * @support  array $productIds 产品id [ require false ]
     * @support  string $streamNum 流水号 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSearchHistory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 云学院提交评价
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @param  string $spotUuid 抽片uuid [ require true ]
     * @param  array $tags 标签id [ require false ]
     * @param  string $picUrl 照片地址 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function commitHistory (string $spotUuid, string $uuid, int $photoId, string $picUrl = '', array $tags = []) {
        return self::getClass()->commitHistory([
            "spotUuid" => $spotUuid,
            "uuid" => $uuid,
            "photoId" => $photoId,
            "picUrl" => $picUrl,
            "tags" => $tags,
        ]);
    }

    /**
     * 获取今日抽片指标
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStatistics () {
        return self::getClass()->getStatistics();
    }

    /**
     * 添加修修兽抽片类别 ---v2.24
     *
     * @param  string $name 类别名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * 修改修修兽抽片类别 ---v2.24
     *
     * @param  int $id 类别id [ require true ]
     * @param  string $name 类别名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editScoreType (int $id, string $name) {
        return self::getClass()->editScoreType([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 获取修修兽抽片配置列表 ---v2.24
     *
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreConfigList (bool $withTrashed = false) {
        return self::getClass()->getScoreConfigList([
            "withTrashed" => $withTrashed,
        ]);
    }

    /**
     * 添加修修兽抽片评分配置---v2.24
     *
     * @param  string $name 评分项名称 [ require true ]
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * 修改修修兽抽片评分配置---v2.24
     *
     * @param  int $id 评分项id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "name" => $name,
            "children" => $children,
        ]);
    }

    /**
     * 删除修修兽抽片评分配置---v2.24
     *
     * @param  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudScoreByGroup (string $startAt, string $endAt, array $productIds = []) {
        return self::getClass()->getCloudScoreByGroup([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  int $scoreTypeId 问题类型id [ require true ]
     * @param  array $tagIds 标签id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProblemByGroup (string $startAt, string $endAt, int $scoreTypeId = 0, array $tagIds = [], array $productIds = []) {
        return self::getClass()->getCloudProblemByGroup([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "scoreTypeId" => $scoreTypeId,
            "tagIds" => $tagIds,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 更新修修兽修改提交评价----2.6更新
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @param  array $tags 标签id [ require false ]
     * @param  string $picUrl 照片地址 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCommitHistory (string $uuid, int $photoId, string $picUrl = '', array $tags = []) {
        return self::getClass()->updateCommitHistory([
            "uuid" => $uuid,
            "photoId" => $photoId,
            "picUrl" => $picUrl,
            "tags" => $tags,
        ]);
    }

    /**
     * 获取更新修修兽修改提交评价记录----2.24更新
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $streamNum 流水号 [ require false ]
     * @support  array $retoucherId 修片师id [ require false ]
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 页码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpdateCommitHistoryLog (int $page, int $pageSize) {
        return self::getClass()->getUpdateCommitHistoryLog([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取老评分列表 ---2.8更新
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOldScoreConfigList () {
        return self::getClass()->getOldScoreConfigList();
    }

    /**
     * 清空云学院记录 ---2.8更新
     *
     * @param  array $staffIds id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function emptyCheckPoolByStaffId (array $staffIds = []) {
        return self::getClass()->emptyCheckPoolByStaffId([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'CheckPool\ShowPicPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'CheckPool\ShowPicPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}