<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitStreamByParams(array $params)
 * @method aiAutoSubmitStreamByParams(array $params)
 * @method joinQueueByParams(array $params)
 * @method exitQueueByParams(array $params)
 * @method receiptStreamByParams(array $params)
 * @method tagStreamByParams(array $params)
 */
class Retoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交已修流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitStream ($context, string $streamNum, array $photoData) {
        return self::getClass()->submitStream([
            "context" => $context,
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * ai提交已修流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function aiAutoSubmitStream ($context, string $streamNum, array $photoData) {
        return self::getClass()->aiAutoSubmitStream([
            "context" => $context,
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 进入队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinQueue ($context) {
        return self::getClass()->joinQueue();
    }

    /**
     * 退出队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitQueue ($context) {
        return self::getClass()->exitQueue();
    }

    /**
     * 主动接单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiptStream ($context) {
        return self::getClass()->receiptStream();
    }

    /**
     * 流水打标签【作为认领的标记】
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  string $retoucherName 外包接单人姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagStream ($context, string $streamNum, string $retoucherName) {
        return self::getClass()->tagStream([
            "context" => $context,
            "streamNum" => $streamNum,
            "retoucherName" => $retoucherName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Retoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Retoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}