<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method disableProductByParams(array $params)
 * @method enableProductByParams(array $params)
 * @method getProductListByIdsByParams(array $params)
 * @method editProductNameByParams(array $params)
 * @method getProductInfoByParams(array $params)
 * @method getProductInfoByIdsByParams(array $params)
 * @method copyProductByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $retouchRequire 修片要求 [ require true ]
     * @support  array $simpleImages 样片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct ($context) {
        return self::getClass()->addProduct([
            "context" => $context,
        ]);
    }

    /**
     * 禁用产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableProduct ($context, int $productId) {
        return self::getClass()->disableProduct([
            "context" => $context,
            "productId" => $productId,
        ]);
    }

    /**
     * 启用产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableProduct ($context, int $productId) {
        return self::getClass()->enableProduct([
            "context" => $context,
            "productId" => $productId,
        ]);
    }

    /**
     * 批量获取产品信息
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  int $photographerOrgId 摄影机构id [ require true ]
     * @support  string $token api_token [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @param  array $columns 额外字段，基础字段：&#039;id&#039;, &#039;name&#039;, &#039;state&#039;, &#039;refuse_reason&#039; [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListByIds (array $productIds, int $page = 1, int $pageSize = 10, int $photographerOrgId, array $columns = []) {
        return self::getClass()->getProductListByIds([
            "productIds" => $productIds,
            "page" => $page,
            "pageSize" => $pageSize,
            "photographerOrgId" => $photographerOrgId,
            "columns" => $columns,
        ]);
    }

    /**
     * 修改产品名称
     *
     * @param  int $productId 产品id [ require true ]
     * @param  string $name 产品name [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editProductName ($context, int $productId, string $name) {
        return self::getClass()->editProductName([
            "context" => $context,
            "productId" => $productId,
            "name" => $name,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * 通过ids获取产品信息
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  array $columns 产品字段 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfoByIds (array $productIds, array $columns = [0 => '*']) {
        return self::getClass()->getProductInfoByIds([
            "productIds" => $productIds,
            "columns" => $columns,
        ]);
    }

    /**
     * 复制产品
     *
     * @param  int $productId 产品id [ require true ]
     * @param  array $updates 更新内容 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function copyProduct ($context, int $productId, array $updates = []) {
        return self::getClass()->copyProduct([
            "context" => $context,
            "productId" => $productId,
            "updates" => $updates,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}