<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLearnPlanListByParams(array $params)
 */
class LearnPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学习列表
     *
     * @support  int $trainingPlanId 培训计划id [ require true ]
     * @support  array $mentorIds 导师ids [ require false ]
     * @support  array $stateIn 学习状态 [ require false ]
     * @support  bool $onlyMarkingToMe 仅查看需要我阅卷考核 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanList ($context) {
        return self::getClass()->getLearnPlanList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}