<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHistoryListByParams(array $params)
 * @method getLearnPlanListByParams(array $params)
 * @method getLearningListByParams(array $params)
 * @method getLearningPlanDetailByParams(array $params)
 * @method getStaffLearnPlanCountByParams(array $params)
 */
class StaffTrain {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 培训历史记录
     *
     * @support  string $titleLike 标题 [ require false ]
     * @support  array $typeIn 考试类型 [ require false ]
     * @support  array $stateIn 学习状态 [ require false ]
     * @support  string $finishAtStart 完成时间开始 [ require false ]
     * @support  string $finishAtEnd 完成时间结束 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList ($context) {
        return self::getClass()->getHistoryList([
            "context" => $context,
        ]);
    }

    /**
     * 我的计划列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanList ($context) {
        return self::getClass()->getLearnPlanList([
            "context" => $context,
        ]);
    }

    /**
     * 我的学习列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearningList ($context) {
        return self::getClass()->getLearningList([
            "context" => $context,
        ]);
    }

    /**
     * 学习计划详情
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearningPlanDetail ($context, int $learningPlanId) {
        return self::getClass()->getLearningPlanDetail([
            "context" => $context,
            "learningPlanId" => $learningPlanId,
        ]);
    }

    /**
     * 获取个人学习计划数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffLearnPlanCount ($context) {
        return self::getClass()->getStaffLearnPlanCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\StaffTrain');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\StaffTrain');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}