<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTodayQuotaByParams(array $params)
 * @method getGroupStaffTodayQuotaListByParams(array $params)
 * @method getStaffQuotaInfoGroupByStaffByParams(array $params)
 * @method getGroupStaffQuotaForCloudSchoolInfoByParams(array $params)
 * @method getGroupStaffQuotaForCloudSchoolInfoByStaffByParams(array $params)
 * @method getGroupStaffScoreForCloudSchoolInfoByStaffByParams(array $params)
 * @method getReworkQuotaGroupByStaffByParams(array $params)
 * @method getStaffRetouchListByParams(array $params)
 * @method getStoreReturnQuotaByParams(array $params)
 * @method getCheckPoolQuotaByParams(array $params)
 * @method getCheckPoolSubQuotaByParams(array $params)
 * @method getCloudProblemReportByGroupByParams(array $params)
 * @method getLittleBeeInfoByParams(array $params)
 * @method getCloudScoreByGroupByParams(array $params)
 * @method getCloudProblemByGroupByParams(array $params)
 * @method getShowPicScoreByGroupByParams(array $params)
 * @method getShowPicProblemByGroupByParams(array $params)
 */
class RetouchLeader {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取今日指标[整组]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTodayQuota ($context) {
        return self::getClass()->getTodayQuota();
    }

    /**
     * 获取组员今日指标列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupStaffTodayQuotaList ($context) {
        return self::getClass()->getGroupStaffTodayQuotaList();
    }

    /**
     * 获取所有组员修图报告[分组]
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffQuotaInfoGroupByStaff ($context) {
        return self::getClass()->getStaffQuotaInfoGroupByStaff([
            "context" => $context,
        ]);
    }

    /**
     * 获取所有组员云学院修图报告统计
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @param  string $staffId ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupStaffQuotaForCloudSchoolInfo ($context, string $staffId = '') {
        return self::getClass()->getGroupStaffQuotaForCloudSchoolInfo([
            "context" => $context,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取所有组员云学院修图报告(柱状图) -----2.4
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @param  array $staffIds ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupStaffQuotaForCloudSchoolInfoByStaff ($context, array $staffIds = []) {
        return self::getClass()->getGroupStaffQuotaForCloudSchoolInfoByStaff([
            "context" => $context,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取所有组员云学院修图评分(条状图) -----2.4
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @param  array $staffIds ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupStaffScoreForCloudSchoolInfoByStaff ($context, array $staffIds = []) {
        return self::getClass()->getGroupStaffScoreForCloudSchoolInfoByStaff([
            "context" => $context,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取所有组员退单报告(条状图) -----2.10
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $staffIds ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReworkQuotaGroupByStaff ($context, string $startAt, string $endAt, array $staffIds = []) {
        return self::getClass()->getReworkQuotaGroupByStaff([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取组员修图记录
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @support  string $evaluate 门店点赞 [ require false ]
     * @support  string $storeReworkType 门店退回 [ require false ]
     * @support  array $retoucherIds 员工id [ require false ]
     * @support  array $cloudTags 云学院问题标签 [ require false ]
     * @support  string $cloudEvaluateType 云学院标签类型 [ require false ]
     * @support  string $passStartAt 审核通过开始时间 [ require false ]
     * @support  string $passEndAt 审核通过结束时间 [ require false ]
     * @support  string $returnStartAt 门店退回开始时间 [ require false ]
     * @support  string $returnEndAt 门店退回结束时间 [ require false ]
     * @support  string $storeEvaluateStartAt 门店评价开始时间 [ require false ]
     * @support  string $storeEvaluateEndAt 门店评价结束时间 [ require false ]
     * @support  string $cloudEvaluateStartAt 云学院评价开始时间 [ require false ]
     * @support  string $cloudEvaluateEndAt 云学院评价结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRetouchList ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffRetouchList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 退单报告模块&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $retouchIds 修片师id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreReturnQuota ($context, string $startAt, string $endAt, array $retouchIds = []) {
        return self::getClass()->getStoreReturnQuota([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retouchIds" => $retouchIds,
        ]);
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @support  array $productIds 云端伙伴id [ require false ]
     * @param  array $retoucherIds 云端产品id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckPoolQuota ($context, string $startAt, string $endAt, array $retoucherIds = []) {
        return self::getClass()->getCheckPoolQuota([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retoucherIds" => $retoucherIds,
        ]);
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @support  string $type 打分类型 [ require false ]
     * @param  array $retoucherIds 云端伙伴id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckPoolSubQuota ($context, string $startAt, string $endAt, array $retoucherIds = []) {
        return self::getClass()->getCheckPoolSubQuota([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "retoucherIds" => $retoucherIds,
        ]);
    }

    /**
     * 获取云学院问题统计(柱状图) ---2.10更新
     *
     * @param  array $tagId 标签id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProblemReportByGroup ($context, string $startAt, string $endAt, array $tagId = []) {
        return self::getClass()->getCloudProblemReportByGroup([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "tagId" => $tagId,
        ]);
    }

    /**
     * [主管]获取小蜜蜂奖励信息－2.8
     *
     * @param  int $year 年份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLittleBeeInfo ($context, int $year) {
        return self::getClass()->getLittleBeeInfo([
            "context" => $context,
            "year" => $year,
        ]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudScoreByGroup ($context, string $startAt, string $endAt, array $productIds = []) {
        return self::getClass()->getCloudScoreByGroup([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  int $scoreTypeId 问题类型id [ require true ]
     * @param  array $tagIds 标签id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProblemByGroup ($context, string $startAt, string $endAt, int $scoreTypeId = 0, array $tagIds = [], array $productIds = []) {
        return self::getClass()->getCloudProblemByGroup([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "scoreTypeId" => $scoreTypeId,
            "tagIds" => $tagIds,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShowPicScoreByGroup ($context, string $startAt, string $endAt, array $productIds = []) {
        return self::getClass()->getShowPicScoreByGroup([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     *
     * @param  array $productIds 产品id [ require false ]
     * @param  int $scoreTypeId 问题类型id [ require true ]
     * @param  array $tagIds 标签id [ require false ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShowPicProblemByGroup ($context, string $startAt, string $endAt, int $scoreTypeId = 0, array $tagIds = [], array $productIds = []) {
        return self::getClass()->getShowPicProblemByGroup([
            "context" => $context,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "scoreTypeId" => $scoreTypeId,
            "tagIds" => $tagIds,
            "productIds" => $productIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}