<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTrainPlanByParams(array $params)
 * @method editTrainPlanByParams(array $params)
 */
class TrainPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建星耀计划
     *
     * @support  string $title 计划标题 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $type 考试类型 [ require true ]
     * @support  mixed $extend 附加内容 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createTrainPlan ($context) {
        return self::getClass()->createTrainPlan([
            "context" => $context,
        ]);
    }

    /**
     * 修改星耀计划配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  string $title 计划标题 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $type 考试类型 [ require true ]
     * @support  mixed $extend 附加内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editTrainPlan ($context) {
        return self::getClass()->editTrainPlan([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}