<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTrainPlanByParams(array $params)
 * @method editTrainPlanByParams(array $params)
 * @method createExamConfigByParams(array $params)
 * @method editExamConfigByParams(array $params)
 * @method createPassConfigByParams(array $params)
 * @method getTrainPlanDetailByParams(array $params)
 * @method getTrainPlanListByParams(array $params)
 */
class TrainPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建星耀计划
     *
     * @support  string $title 计划标题 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $type 考试类型 [ require true ]
     * @support  mixed $extend 附加内容 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createTrainPlan ($context) {
        return self::getClass()->createTrainPlan([
            "context" => $context,
        ]);
    }

    /**
     * 修改星耀计划配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  string $title 计划标题 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $type 考试类型 [ require true ]
     * @support  mixed $extend 附加内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editTrainPlan ($context) {
        return self::getClass()->editTrainPlan([
            "context" => $context,
        ]);
    }

    /**
     * 考核配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  int $examDuration 考核时长，秒 [ require true ]
     * @support  mixed $examConfig 修图考核配置 [ require false ]
     * @support  mixed $questions 试题配置 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function createExamConfig ($context) {
        return self::getClass()->createExamConfig([
            "context" => $context,
        ]);
    }

    /**
     * 考核配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  int $examConfigId 试题考核配置id [ require true ]
     * @support  int $examDuration 考核时长，秒 [ require true ]
     * @support  mixed $examConfig 修图考核配置 [ require false ]
     * @support  mixed $questions 试题配置 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function editExamConfig ($context) {
        return self::getClass()->editExamConfig([
            "context" => $context,
        ]);
    }

    /**
     * 通关配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  int $retouchClassId 通关可接修图类别id [ require false ]
     * @support  array $passProductConfig 通关可接产品 [ require false ]
     * @support  array $retoucherIds 培训伙伴ids [ require true ]
     * @support  array $markingMentorIds 阅读导师ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPassConfig ($context) {
        return self::getClass()->createPassConfig([
            "context" => $context,
        ]);
    }

    /**
     * 获取星耀计划配置详情
     *
     * @param  int $planId 计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTrainPlanDetail (int $planId) {
        return self::getClass()->getTrainPlanDetail([
            "planId" => $planId,
        ]);
    }

    /**
     * 星耀培训计划列表
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  array $typeIn 考试类型 [ require false ]
     * @support  array $stateIn 学习状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTrainPlanList ($context) {
        return self::getClass()->getTrainPlanList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}