<?php
namespace Mainto\Bridge\Enums\ProjectCloud\Appeal;

class StreamAppealStateEnum {
    /**
     * 等待初审
     */
    const STREAM_APPEAL_STATE_WAIT_ST = 'wait_first';
    /**
     * 初审中
     */
    const STREAM_APPEAL_STATE_ST_EXAMINE = 'first_examine';
    /**
     * 等待复审
     */
    const STREAM_APPEAL_STATE_WAIT_SC = 'wait_second';
    /**
     * 复审中
     */
    const STREAM_APPEAL_STATE_SC_EXAMINE = 'second_examine';
    /**
     * 处理完成
     */
    const FINISH = 'finish';
    /**
     * 超时未处理
     */
    const EXPIRE = 'expire';
    const STREAM_APPEAL_STATE_MAP = [0 => 'wait_first',1 => 'first_examine',2 => 'wait_second',3 => 'second_examine',4 => 'finish',5 => 'expire'];
    /**
     * 下一阶段映射
     */
    const STREAM_APPEAL_NEXT_STATE_MAP = ['wait_first' => 'first_examine','first_examine' => 'wait_second','wait_second' => 'second_examine','second_examine' => 'finish'];
    /**
     * 处于已经结束的单据
     */
    const STREAM_APPEAL_END_STATE_MAP = [0 => 'finish',1 => 'expire'];
}