<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRegionMentorsByParams(array $params)
 * @method addRegionMentorByParams(array $params)
 * @method editRegionMentorByParams(array $params)
 * @method delRegionMentorByParams(array $params)
 * @method addRegionRetouchGroupByParams(array $params)
 * @method delRegionRetouchGroupByParams(array $params)
 * @method getRetouchGroupWithNotBindByParams(array $params)
 * @method getMentorWithNotBindByParams(array $params)
 */
class RegionMentor {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 区域导师列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRegionMentors () {
        return self::getClass()->getRegionMentors();
    }

    /**
     * 添加区域导师
     *
     * @param  string $regionName 区域名称 [ require true ]
     * @param  int $mentorId 导师id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRegionMentor (string $regionName, int $mentorId) {
        return self::getClass()->addRegionMentor([
            "regionName" => $regionName,
            "mentorId" => $mentorId,
        ]);
    }

    /**
     * 修改区域导师
     *
     * @param  int $id 区域导师表id [ require true ]
     * @param  string $regionName 区域名称 [ require true ]
     * @param  int $mentorId 导师id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editRegionMentor (int $id, string $regionName, int $mentorId) {
        return self::getClass()->editRegionMentor([
            "id" => $id,
            "regionName" => $regionName,
            "mentorId" => $mentorId,
        ]);
    }

    /**
     * 删除区域导师
     *
     * @param  int $id 区域导师表id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delRegionMentor (int $id) {
        return self::getClass()->delRegionMentor([
            "id" => $id,
        ]);
    }

    /**
     * 添加区域修图组
     *
     * @param  int $regionMentorId 区域导师表id [ require true ]
     * @param  array $retouchGroupIds 修图组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addRegionRetouchGroup (int $regionMentorId, array $retouchGroupIds) {
        return self::getClass()->addRegionRetouchGroup([
            "regionMentorId" => $regionMentorId,
            "retouchGroupIds" => $retouchGroupIds,
        ]);
    }

    /**
     * 删除区域修图组
     *
     * @param  int $id 区域修图组绑定表id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delRegionRetouchGroup (int $id) {
        return self::getClass()->delRegionRetouchGroup([
            "id" => $id,
        ]);
    }

    /**
     * 获取未被绑定的修图组
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetouchGroupWithNotBind () {
        return self::getClass()->getRetouchGroupWithNotBind();
    }

    /**
     * 获取未被绑定的导师
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMentorWithNotBind () {
        return self::getClass()->getMentorWithNotBind();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'RegionMentor');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'RegionMentor');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}