<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createHimoNpsByParams(array $params)
 * @method outStreamWaitReviewByParams(array $params)
 * @method outStreamWaitReviewedByParams(array $params)
 * @method staffPositionUpdateByParams(array $params)
 * @method hookQuotaEventByParams(array $params)
 * @method hookStaffPassProductsByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听创建NPS记录
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $retoucherScore 修片师分数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createHimoNps (string $orderNo, int $retoucherScore) {
        return self::getClass()->createHimoNps([
            "orderNo" => $orderNo,
            "retoucherScore" => $retoucherScore,
        ]);
    }

    /**
     * 监听外包审核状态-等待审核
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReview (string $streamId) {
        return self::getClass()->outStreamWaitReview([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 监听外包审核状态-审核中
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReviewed (string $streamId) {
        return self::getClass()->outStreamWaitReviewed([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 监听岗位变动
     *
     * @param  int $staffId staffId [ require true ]
     * @param  int $originalPositionId 原岗位id [ require true ]
     * @param  int $positionId 变更后岗位id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffPositionUpdate (int $staffId, int $originalPositionId, int $positionId) {
        return self::getClass()->staffPositionUpdate([
            "staffId" => $staffId,
            "originalPositionId" => $originalPositionId,
            "positionId" => $positionId,
        ]);
    }

    /**
     * 监听指标变动
     *
     * @support  string $item_name item_name [ require true ]
     * @support  int $object_id object_id [ require true ]
     * @support  string $type type [ require true ]
     * @support  int $cycle cycle [ require true ]
     * @support  float $value value [ require true ]
     * @support  string $event event [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookQuotaEvent ($context) {
        return self::getClass()->hookQuotaEvent([
            "context" => $context,
        ]);
    }

    /**
     * 伙伴通关卡
     * #todo 还未联调
     *
     * @param  int $staffId item_name [ require true ]
     * @param  array $productIds 通关产品ids [ require false ]
     * @param  int $retouchClassId 通关产品类别 [ require false ]
     * @param  string $type 通关类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStaffPassProducts (int $staffId, string $type, array $productIds = [], int $retouchClassId = null) {
        return self::getClass()->hookStaffPassProducts([
            "staffId" => $staffId,
            "type" => $type,
            "productIds" => $productIds,
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}