<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLearnPlanListByParams(array $params)
 * @method getLearnPlanTotalByParams(array $params)
 * @method getLearnPlanPlanDetailByParams(array $params)
 * @method urgedCompleteByParams(array $params)
 * @method urgedMarkingByParams(array $params)
 */
class LearnPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学习列表
     *
     * @support  int $trainingPlanId 培训计划id [ require true ]
     * @support  array $mentorIds 导师ids [ require false ]
     * @support  array $stateIn 学习状态 [ require false ]
     * @support  bool $onlyMarkingToMe 仅查看需要我阅卷考核 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanList ($context) {
        return self::getClass()->getLearnPlanList([
            "context" => $context,
        ]);
    }

    /**
     * 学习列表
     *
     * @param  int $trainingPlanId 培训计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanTotal (int $trainingPlanId) {
        return self::getClass()->getLearnPlanTotal([
            "trainingPlanId" => $trainingPlanId,
        ]);
    }

    /**
     * 学习计划详情
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnPlanPlanDetail ($context, int $learningPlanId) {
        return self::getClass()->getLearnPlanPlanDetail([
            "context" => $context,
            "learningPlanId" => $learningPlanId,
        ]);
    }

    /**
     * 催促完成
     *
     * @param  int $planId 配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function urgedComplete (int $planId) {
        return self::getClass()->urgedComplete([
            "planId" => $planId,
        ]);
    }

    /**
     * 催促阅卷
     *
     * @param  int $planId 配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function urgedMarking (int $planId) {
        return self::getClass()->urgedMarking([
            "planId" => $planId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\LearnPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}