<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\CreateTrainPlan $params)
 * @method editTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\EditTrainPlan $params)
 * @method createExamConfigByParams(array $params)
 * @method editExamConfigByParams(array $params)
 * @method createPassConfigByParams(array $params)
 * @method getTrainPlanDetailByParams(array $params)
 * @method getTrainPlanListByParams(array $params)
 * @method getExamConfigDetailByParams(array $params)
 * @method saveTrainPlanDraftByParams(array $params)
 * @method getTrainPlanDraftByParams(array $params)
 */
class TrainPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建星耀计划
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\CreateTrainPlan $params
     * @throws  \Exception
     * @return  int
     */
    public static function createTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\CreateTrainPlan $params) {
        return self::getClass()->createTrainPlan($params);
    }


    /**
     * 修改星耀计划配置
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\EditTrainPlan $params
     * @throws  \Exception
     * @return  bool
     */
    public static function editTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\EditTrainPlan $params) {
        return self::getClass()->editTrainPlan($params);
    }


    /**
     * 考核配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  string $draftUuid 当前草稿uuid [ require true ]
     * @support  int $examDuration 考核时长，秒 [ require true ]
     * @support  mixed $examConfig 修图考核配置 [ require false ]
     * @support  mixed $questions 试题配置 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function createExamConfig ($context) {
        return self::getClass()->createExamConfig([
            "context" => $context,
        ]);
    }

    /**
     * 修改考核配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  int $examConfigId 试题考核配置id [ require true ]
     * @support  int $examDuration 考核时长，秒 [ require true ]
     * @support  mixed $examConfig 修图考核配置 [ require false ]
     * @support  mixed $questions 试题配置 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function editExamConfig ($context) {
        return self::getClass()->editExamConfig([
            "context" => $context,
        ]);
    }

    /**
     * 通关配置
     *
     * @support  int $planId 计划id [ require true ]
     * @support  string $draftUuid 当前草稿uuid [ require true ]
     * @support  int $retouchClassId 通关可接修图类别id [ require false ]
     * @support  array $passProductConfig 通关可接产品 [ require false ]
     * @support  array $retoucherIds 培训伙伴ids [ require true ]
     * @support  array $markingMentorIds 阅读导师ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPassConfig ($context) {
        return self::getClass()->createPassConfig([
            "context" => $context,
        ]);
    }

    /**
     * 获取星耀计划配置详情
     *
     * @param  int $planId 计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTrainPlanDetail (int $planId) {
        return self::getClass()->getTrainPlanDetail([
            "planId" => $planId,
        ]);
    }

    /**
     * 星耀培训计划列表
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  array $typeIn 考试类型 [ require false ]
     * @support  array $stateIn 培训状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTrainPlanList ($context) {
        return self::getClass()->getTrainPlanList([
            "context" => $context,
        ]);
    }

    /**
     * 获取试题配置详情
     *
     * @param  int $planId 计划id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExamConfigDetail (int $planId) {
        return self::getClass()->getExamConfigDetail([
            "planId" => $planId,
        ]);
    }

    /**
     * 草稿存储
     *
     * @param  array $contentArr 内容 [ require true ]
     * @param  string $step 当前停留步骤 [ require true ]
     * @param  int $planId 计划id [ require false ]
     * @param  int $draftUuid 计划id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveTrainPlanDraft ($context, array $contentArr, string $step, int $planId = null, int $draftUuid) {
        return self::getClass()->saveTrainPlanDraft([
            "context" => $context,
            "contentArr" => $contentArr,
            "step" => $step,
            "planId" => $planId,
            "draftUuid" => $draftUuid,
        ]);
    }

    /**
     * 创建星耀培训计划--获取草稿
     *
     * @param  int $planId 计划id, 在编辑数据的时候入参 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTrainPlanDraft ($context, int $planId = null) {
        return self::getClass()->getTrainPlanDraft([
            "context" => $context,
            "planId" => $planId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Trainning\TrainPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}