<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductListByParams(array $params)
 * @method passProductByParams(array $params)
 * @method editProductByParams(array $params)
 * @method refuseProductByParams(array $params)
 * @method delProductByParams(array $params)
 * @method getProductInfoByParams(array $params)
 * @method searchProductsByParams(array $params)
 * @method getQueueWeightTypeListByParams(array $params)
 * @method getAllQueueWeightTypeByParams(array $params)
 * @method addQueueWeightTypeByParams(array $params)
 * @method editQueueWeightTypeByParams(array $params)
 * @method refreshQueueByParams(array $params)
 * @method canRefreshQueueByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品列表-2.26
     *
     * @support  int $photographerOrgId 摄影机构 require false
     * @support  array $productId 产品id require false
     * @support  string $state 状态 [ require true ]
     * @support  string $weightLevel 权重等级 require false
     * @support  int $weightSettingId 权重配置id require false
     * @support  array $productCategoryIdIn 分类id查询 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 审核通过--3.30.2
     *
     * @param  int $productId 产品id [ require true ]
     * @support  string $retouchStandard 修片标准 require false
     * @support  string $weightLevel 权重等级 require false
     * @support  bool $needSplicing 是否拼接 [ require true ]
     * @support  bool $needTemplate 是否有模板照 [ require true ]
     * @support  string $templateSuffix 模板照后缀 require false
     * @support  array $normalIncomeConfig 普通收益 [ require true ]
     * @support  array $splicingIncomeConfig 拼接收益 require false
     * @support  array $seaGrassConfig 海草收益 [ require true ]
     * @support  array $splicingSeaGrassConfig 拼接的海草收益 require false
     * @support  int $productCategoryId 产品分类id [ require true ]
     * @support  bool $forceReview 是否强制审核 [ require true ]
     * @support  string $forceReviewStartAt 强制审核开始时间点 require false
     * @support  string $forceReviewEndAt 强制审核结束时间点 require false
     * @support  string $forceReviewDayStart 强制审核每日开始时间 require false
     * @support  string $forceReviewDayEnd 强制审核每日结束时间 require false
     * @support  string $note 备注 require false
     * @support  array $technicalPoints 技术要点 require false
     * @support  array $textureName 贴图名称 require false
     * @support  int $weightSettingId 权重配置id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function passProduct (int $productId) {
        return self::getClass()->passProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 修改产品--2.27
     *
     * @param  int $productId 产品id [ require true ]
     * @support  string $retouchStandard 修片标准 require false
     * @support  string $weightLevel 权重等级 require false
     * @support  bool $needSplicing 是否拼接 require false
     * @support  bool $needTemplate 是否有模板照 require false
     * @support  string $templateSuffix 模板照后缀 require false
     * @support  array $normalIncomeConfig 普通收益 require false
     * @support  array $splicingIncomeConfig 拼接收益 require false
     * @support  array $seaGrassConfig 海草收益 require false
     * @support  array $splicingSeaGrassConfig 拼接的海草收益 require false
     * @support  int $productCategoryId 产品分类 require false
     * @support  string $note 备注 require false
     * @support  bool $forceReview 是否强制审核 require false
     * @support  string $forceReviewStartAt 强制审核开始时间点 require false
     * @support  string $forceReviewEndAt 强制审核结束时间点 require false
     * @support  string $forceReviewDayStart 强制审核每日开始时间 require false
     * @support  string $forceReviewDayEnd 强制审核每日结束时间 require false
     * @support  array $textureName 贴图名称 require false
     * @support  int $weightSettingId 权重配置id require false
     * @support  array $technicalPoints 拍摄底色 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editProduct (int $productId) {
        return self::getClass()->editProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 审核拒绝
     *
     * @param  int $productId 产品id [ require true ]
     * @param  string $refuseReason 退回原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuseProduct (int $productId, string $refuseReason) {
        return self::getClass()->refuseProduct([
            "productId" => $productId,
            "refuseReason" => $refuseReason,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delProduct (int $productId) {
        return self::getClass()->delProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品详情--2.27
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * 搜索产品
     *
     * @param  array $photographerOrgIds 机构id [ require true ]
     * @param  array $retouchStandards 修图标准 [ require true ]
     * @support  bool $productCategoryIdIn 是否需要已删除数据 require false
     * @param  bool $needDeleted 是否需要已删除数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchProducts (array $photographerOrgIds = [], array $retouchStandards = [], bool $needDeleted = false) {
        return self::getClass()->searchProducts([
            "photographerOrgIds" => $photographerOrgIds,
            "retouchStandards" => $retouchStandards,
            "needDeleted" => $needDeleted,
        ]);
    }

    /**
     * 获取队列权重类别列表(分页)----2.26更新
     *
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页大小 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueWeightTypeList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getQueueWeightTypeList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取所有队列权重类别列表----2.26更新
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllQueueWeightType () {
        return self::getClass()->getAllQueueWeightType();
    }

    /**
     * 队列权重类别添加----2.26更新
     *
     * @support  string $name 类别名称 require false
     * @support  int $weight 自身权重 [ require true ]
     * @support  int $increase_weight 每小时增加权重 [ require true ]
     * @support  int $urgent_weight 加急 [ require true ]
     * @support  array $customer_urgent_weight 会员加急 [ require true ]
     * @support  mixed $take_photo_time_set 约定取片时长 [ require true ]
     * @support  int $critical_increase_weight 临界增加权重值 [ require true ]
     * @support  mixed $critical_take_photo_time 临界取片时长 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addQueueWeightType () {
        return self::getClass()->addQueueWeightType();
    }

    /**
     * 队列权重类别编辑----2.26更新
     *
     * @param  int $id 类别id [ require true ]
     * @support  string $name 类别名称 require false
     * @support  int $weight 自身权重 [ require true ]
     * @support  int $increase_weight 每小时增加权重 [ require true ]
     * @support  int $urgent_weight 加急 [ require true ]
     * @support  array $customer_urgent_weight 会员加急 [ require true ]
     * @support  mixed $take_photo_time_set 约定取片时长 [ require true ]
     * @support  int $critical_increase_weight 临界增加权重值 [ require true ]
     * @support  mixed $critical_take_photo_time 临界取片时长 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editQueueWeightType (int $id) {
        return self::getClass()->editQueueWeightType([
            "id" => $id,
        ]);
    }

    /**
     * 刷新队列----2.26更新
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function refreshQueue () {
        return self::getClass()->refreshQueue();
    }

    /**
     * 是否能刷新队列----2.26更新
     *
     * @throws  \Exception
     * @return  int
     */
    public static function canRefreshQueue () {
        return self::getClass()->canRefreshQueue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}