<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfInfoByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method getAllRetouchClassByParams(array $params)
 * @method getAllProductByParams(array $params)
 * @method getProductCategoryTreeByParams(array $params)
 * @method getAllRoleByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getRetouchOrgListByParams(array $params)
 * @method getProductInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getStaffListByParams(array $params)
 * @method getWaitRetouchStreamQueueByParams(array $params)
 * @method streamToRetoucherByParams(array $params)
 * @method streamToReviewerByParams(array $params)
 * @method delWaitRetoucherQueueByParams(array $params)
 * @method staffExitStreamByParams(array $params)
 * @method rePushStreamQueueByParams(array $params)
 * @method pushRetoucherByParams(array $params)
 * @method pushReviewerByParams(array $params)
 * @method pullRetoucherByParams(array $params)
 * @method pullReviewerByParams(array $params)
 * @method getSelfStaffsByParams(array $params)
 * @method getCloudRetoucherByParams(array $params)
 * @method getReviewerByParams(array $params)
 * @method getRetoucherGroupByParams(array $params)
 * @method getPhotographerOrgByParams(array $params)
 * @method getRetoucherOrgByParams(array $params)
 * @method getRetoucherOrgWithProductByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method streamTimeRpcLogByParams(array $params)
 * @method getCacheCountByParams(array $params)
 * @method incrCacheCountByParams(array $params)
 * @method getWebSocketSignatureByParams(array $params)
 * @method webSocketByParams(array $params)
 * @method getRetoucherLeadersByParams(array $params)
 * @method getOnlineStateByParams(array $params)
 * @method wsOfflineByParams(array $params)
 * @method getPhotoProblemTagSetsByParams(array $params)
 * @method addVersionInfoByParams(array $params)
 * @method updateVersionInfoByParams(array $params)
 * @method getVersionInfoForPaginateByParams(array $params)
 * @method getAllVersionNumByParams(array $params)
 * @method getAnniversaryInfoByParams(array $params)
 * @method getBackColorsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前个人信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSelfInfo ($context) {
        return self::getClass()->getSelfInfo();
    }

    /**
     * 获取流水信息
     *
     * @param  int $streamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamInfo (int $streamId) {
        return self::getClass()->getStreamInfo([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取全部修图类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRetouchClass () {
        return self::getClass()->getAllRetouchClass();
    }

    /**
     * 获取全部产品--2.24
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct();
    }

    /**
     * 根据根节点id获取产品分类树--2.24
     *
     * @param  int $rootId 根分类节点id，获取整树所有则传0 [ require true ]
     * @param  bool $withProduct 是否需要产品列表,默认为false [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return self::getClass()->getProductCategoryTree([
            "rootId" => $rootId,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * 获取全部角色组
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRole () {
        return self::getClass()->getAllRole();
    }

    /**
     * 获取订单信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取所有修图机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetouchOrgList () {
        return self::getClass()->getRetouchOrgList();
    }

    /**
     * 获取产品信息
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthority ($context) {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取伙伴列表
     *
     * @param  bool $needDelete 需要禁用的账户 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffList (bool $needDelete = false) {
        return self::getClass()->getStaffList([
            "needDelete" => $needDelete,
        ]);
    }

    /**
     * test获取队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWaitRetouchStreamQueue ($context) {
        return self::getClass()->getWaitRetouchStreamQueue();
    }

    /**
     * test指定修片师
     *
     * @support  int $staffId staffId [ require true ]
     * @support  int $streamId streamId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamToRetoucher ($context) {
        return self::getClass()->streamToRetoucher([
            "context" => $context,
        ]);
    }

    /**
     * test指定审核人
     *
     * @support  int $staffId staffId [ require true ]
     * @support  int $streamId streamId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamToReviewer ($context) {
        return self::getClass()->streamToReviewer([
            "context" => $context,
        ]);
    }

    /**
     * test清空队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function delWaitRetoucherQueue ($context) {
        return self::getClass()->delWaitRetoucherQueue();
    }

    /**
     * 修片解绑-test-辅助
     *
     * @support  string $streamNum streamNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffExitStream ($context) {
        return self::getClass()->staffExitStream([
            "context" => $context,
        ]);
    }

    /**
     * 重推修片&amp;审核队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rePushStreamQueue ($context) {
        return self::getClass()->rePushStreamQueue();
    }

    /**
     * 人员推到队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushRetoucher ($context) {
        return self::getClass()->pushRetoucher([
            "context" => $context,
        ]);
    }

    /**
     * 人员推到审核队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushReviewer ($context) {
        return self::getClass()->pushReviewer([
            "context" => $context,
        ]);
    }

    /**
     * 人员推出修片队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pullRetoucher ($context) {
        return self::getClass()->pullRetoucher([
            "context" => $context,
        ]);
    }

    /**
     * 人员推出审核队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pullReviewer ($context) {
        return self::getClass()->pullReviewer([
            "context" => $context,
        ]);
    }

    /**
     * 获取自己所有组员
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSelfStaffs ($context) {
        return self::getClass()->getSelfStaffs();
    }

    /**
     * 获取云端所有修图师
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudRetoucher () {
        return self::getClass()->getCloudRetoucher();
    }

    /**
     * 获取所有审核人
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReviewer () {
        return self::getClass()->getReviewer();
    }

    /**
     * 获取所有修图组
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherGroup () {
        return self::getClass()->getRetoucherGroup();
    }

    /**
     * 获取摄影机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotographerOrg () {
        return self::getClass()->getPhotographerOrg();
    }

    /**
     * 获取修片机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherOrg () {
        return self::getClass()->getRetoucherOrg();
    }

    /**
     * 获取修片机构及可接产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherOrgWithProduct () {
        return self::getClass()->getRetoucherOrgWithProduct();
    }

    /**
     * test初始化当日随机数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 记录流水时间点
     *
     * @support  int $streamId 流水id [ require true ]
     * @support  string $event 事件名 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamTimeRpcLog ($context) {
        return self::getClass()->streamTimeRpcLog([
            "context" => $context,
        ]);
    }

    /**
     * 获取缓存
     *
     * @param  string $cacheKey 缓存key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCacheCount ($context, string $cacheKey) {
        return self::getClass()->getCacheCount([
            "context" => $context,
            "cacheKey" => $cacheKey,
        ]);
    }

    /**
     * 递增缓存
     *
     * @param  string $cacheKey 缓存key [ require true ]
     * @param  int $increment 递增/递减值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incrCacheCount ($context, string $cacheKey, int $increment = 1) {
        return self::getClass()->incrCacheCount([
            "context" => $context,
            "cacheKey" => $cacheKey,
            "increment" => $increment,
        ]);
    }

    /**
     * 获取ws票据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWebSocketSignature ($context) {
        return self::getClass()->getWebSocketSignature();
    }

    /**
     * webSocket入口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function webSocket ($context) {
        return self::getClass()->webSocket();
    }

    /**
     * 获取修片主管和运营主管
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherLeaders () {
        return self::getClass()->getRetoucherLeaders();
    }

    /**
     * 获取全局在线状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineState () {
        return self::getClass()->getOnlineState();
    }

    /**
     * wsOffline
     *
     * @param  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function wsOffline (int $staffId) {
        return self::getClass()->wsOffline([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取摄影化妆问题标签
     *
     * @param  string $about photography/makeup [ require false ]
     * @param  bool $withDeleted true/false [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoProblemTagSets ($context, string $about = null, bool $withDeleted = false) {
        return self::getClass()->getPhotoProblemTagSets([
            "context" => $context,
            "about" => $about,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * 添加版本更新信息
     *
     * @support  string $versionNum 版本号 [ require true ]
     * @support  string $info 版本更新信息 [ require true ]
     * @support  string $versionTime 版本时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addVersionInfo ($context) {
        return self::getClass()->addVersionInfo([
            "context" => $context,
        ]);
    }

    /**
     * 修改版本更新信息
     *
     * @param  int $id id [ require true ]
     * @support  string $versionNum 版本号 [ require false ]
     * @support  string $info 版本更新信息 [ require false ]
     * @support  string $versionTime 版本时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateVersionInfo ($context, int $id) {
        return self::getClass()->updateVersionInfo([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 获取版本更新信息分页
     *
     * @param  string $versionNum 版本号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVersionInfoForPaginate (string $versionNum = '', int $page = 0, int $pageSize = 10) {
        return self::getClass()->getVersionInfoForPaginate([
            "versionNum" => $versionNum,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 过去所有版本号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllVersionNum () {
        return self::getClass()->getAllVersionNum();
    }

    /**
     * 获取周年庆个人信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAnniversaryInfo ($context) {
        return self::getClass()->getAnniversaryInfo();
    }

    /**
     * 获取修图底色列表--2.27
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBackColors () {
        return self::getClass()->getBackColors();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}