<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getGroupReviewQuotaByParams(array $params)
 * @method getReviewListByParams(array $params)
 */
class ReviewLeader {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取小组审核指标[整小组或者个人]
     *
     * @support  string $range 自己审核还是组员审核 [ require false ]
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  int $staffId 伙伴id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupReviewQuota ($context) {
        return self::getClass()->getGroupReviewQuota([
            "context" => $context,
        ]);
    }

    /**
     * 获取审核记录列表
     *
     * @support  string $range 自己审核还是组员审核 [ require false ]
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $plantOrPull 审核种拔草 [ require false ]
     * @support  string $rectify 纠偏意见 [ require false ]
     * @support  string $rectifyGrass 纠偏种拔草 [ require false ]
     * @support  string $spotCheckPlantOrPull 抽查种拔草 [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @param  int $page page [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReviewList ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getReviewList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'ReviewLeader');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'ReviewLeader');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}