<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRetouchStylesByParams(array $params)
 * @method getTechnicalPointsByParams(array $params)
 * @method submitRetouchStandardByParams(array $params)
 */
class RetouchDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取修图风格列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchStyles () {
        return self::getClass()->getRetouchStyles();
    }

    /**
     * 获取产品下所有技术要点
     *
     * @support  array $productIds 产品ids require false
     * @support  array $ids 技术要点ids require false
     * @throws  \Exception
     * @return  array
     */
    public static function getTechnicalPoints () {
        return self::getClass()->getTechnicalPoints();
    }

    /**
     * 提交修图满意度
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  array $retouchStyle 修图风格 require false
     * @support  string $conceptImg 意向图 require false
     * @support  string $sample 样片 require false
     * @support  string $retoucherAttitudes 点赞拉踩 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function submitRetouchStandard () {
        return self::getClass()->submitRetouchStandard();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\RetouchDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\RetouchDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}