<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addBackColorByParams(array $params)
 * @method editBackColorByParams(array $params)
 * @method delBackColorByParams(array $params)
 * @method getBackColorListByParams(array $params)
 */
class BackColor {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增底色图片
     *
     * @support  string $name 底色名称 [ require true ]
     * @support  string $type 类型 
     * @support  string $img_path 图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addBackColor () {
        return self::getClass()->addBackColor();
    }

    /**
     * 修改底色图片
     *
     * @support  int $id 主键 [ require true ]
     * @support  string $name 底色名称 [ require true ]
     * @support  string $type 类型 
     * @support  string $img_path 图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editBackColor () {
        return self::getClass()->editBackColor();
    }

    /**
     * 删除底色图片
     *
     * @param  int $id 主键 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function delBackColor (int $id) {
        return self::getClass()->delBackColor([
            "id" => $id,
        ]);
    }

    /**
     * 修图底色列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBackColorList (int $page, int $pageSize = 10) {
        return self::getClass()->getBackColorList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'BackColor');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'BackColor');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}