<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinQueueByParams(array $params)
 * @method exitQueueByParams(array $params)
 * @method haveReworkStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method getRetouchStreamsByParams(array $params)
 * @method getStreamQueueInfoByParams(array $params)
 * @method submitStreamByParams(array $params)
 * @method hangStreamByParams(array $params)
 * @method getRankInfoByParams(array $params)
 * @method getPropsByParams(array $params)
 * @method usePropByParams(array $params)
 * @method getLittleBeeInfoByParams(array $params)
 * @method getRetouchQuotaListByParams(array $params)
 * @method getSelfBuffInfoByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getOnlineStateByParams(array $params)
 * @method getCheckPoolQuotaByParams(array $params)
 * @method getCheckPoolSubQuotaByParams(array $params)
 * @method getShowPicPoolSubQuotaByParams(array $params)
 * @method getAppealListByParams(array $params)
 * @method appealDetailByParams(array $params)
 */
class Retoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 进入队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinQueue () {
        return self::getClass()->joinQueue();
    }

    /**
     * 退出队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitQueue () {
        return self::getClass()->exitQueue();
    }

    /**
     * 有流水退单[有就返回流水单号]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveReworkStream () {
        return self::getClass()->haveReworkStream();
    }

    /**
     * 获取流水信息[沙漏时间会自减]--2.27
     *
     * @param  int $streamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamInfo (int $streamId) {
        return self::getClass()->getStreamInfo([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取流水列表[待修，挂起]
     *
     * @param  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetouchStreams (string $state) {
        return self::getClass()->getRetouchStreams([
            "state" => $state,
        ]);
    }

    /**
     * 获取待修片队列信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamQueueInfo () {
        return self::getClass()->getStreamQueueInfo();
    }

    /**
     * 提交已修流水
     *
     * @support  int $streamId 流水号 [ require true ]
     * @support  array $photoData 照片数据 [ require true ]
     * @support  array $streamTagData 标签[目前已流水维度],[&#039;problemTagPhotography&#039;=&gt;[1],&#039;problemTagMakeup&#039;=&gt;[2]] require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitStream () {
        return self::getClass()->submitStream();
    }

    /**
     * 挂起流水[仅能挂起缦图订单]
     *
     * @param  int $streamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangStream (int $streamId) {
        return self::getClass()->hangStream([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取个人修图等级信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRankInfo () {
        return self::getClass()->getRankInfo();
    }

    /**
     * 获取道具
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProps () {
        return self::getClass()->getProps();
    }

    /**
     * 使用道具
     *
     * @param  int $id 道具id[目前只有卡片] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useProp (int $id) {
        return self::getClass()->useProp([
            "id" => $id,
        ]);
    }

    /**
     * 获取小蜜蜂奖励信息
     *
     * @param  int $year 年份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLittleBeeInfo (int $year) {
        return self::getClass()->getLittleBeeInfo([
            "year" => $year,
        ]);
    }

    /**
     * 获取历史修图报告列表&lt;2.10更新接口&gt;
     *
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @support  bool $isReturn 是否退回 require false
     * @support  string $cloudEvaluateType 云学院抽片类型 require false
     * @support  bool $isReturned 是否被退回 require false
     * @support  string $evaluate 门店点赞 require false
     * @support  string $storeReworkType 退回类型 require false
     * @support  array $cloudTags 云学院问题标签 require false
     * @param  string $streamNum 流水号 [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetouchQuotaList (string $streamNum = '', string $startAt = '', string $endAt = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRetouchQuotaList([
            "streamNum" => $streamNum,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取个人buff信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSelfBuffInfo () {
        return self::getClass()->getSelfBuffInfo();
    }

    /**
     * 在线
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function online () {
        return self::getClass()->online();
    }

    /**
     * 离线
     *
     * @support  string $action 自主/自动 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline () {
        return self::getClass()->offline();
    }

    /**
     * 获取在线状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOnlineState () {
        return self::getClass()->getOnlineState();
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @support  array $retoucherIds 云端伙伴id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckPoolQuota (string $startAt, string $endAt) {
        return self::getClass()->getCheckPoolQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * 获取组员云学院报告绩效&lt;2.24更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt) {
        return self::getClass()->getCheckPoolSubQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * 获取组员修修兽抽片报告绩效&lt;2.24更新接口&gt;
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShowPicPoolSubQuota (string $startAt, string $endAt) {
        return self::getClass()->getShowPicPoolSubQuota([
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * 修图师自身申诉列表-v2.12
     *
     * @support  mixed $cond  require false
     * @support  array $cond 查询条件 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAppealList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 申诉详情-v2.12
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Retoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Retoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}