<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method autoEndImpulseByParams(array $params)
 * @method expireImpulseByParams(array $params)
 * @method autoEndStaffCardByParams(array $params)
 * @method expireStaffCardByParams(array $params)
 * @method yearAwardByParams(array $params)
 * @method updateStreamTakeTimeByParams(array $params)
 * @method unbindRetoucherOrgStreamByParams(array $params)
 * @method impulseAutoUsingByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method logQueueInfoByParams(array $params)
 * @method staffLevelCheckByParams(array $params)
 * @method autoOfflineByParams(array $params)
 * @method autoGroupRankFlushMonthByParams(array $params)
 * @method autoStaffRankFlushMonthByParams(array $params)
 * @method autoGroupRankFlushDayByParams(array $params)
 * @method autoExpireStreamAppealByParams(array $params)
 * @method autoSendRetoucherLeaderAppealExamineByParams(array $params)
 * @method autoSendAppealManagerExamineByParams(array $params)
 * @method syncStaffDayScheduleByParams(array $params)
 * @method initDayAlarmLogByParams(array $params)
 * @method sendDayPhotoThroughputNoticeByParams(array $params)
 * @method photoAlarmCheckByParams(array $params)
 * @method reportMonitorByParams(array $params)
 * @method queueStreamStartByParams(array $params)
 * @method queueStreamByParams(array $params)
 * @method sendKpiSetMessageByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动结束冲量buff
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndImpulse () {
        return self::getClass()->autoEndImpulse();
    }

    /**
     * 过期冲量奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireImpulse () {
        return self::getClass()->expireImpulse();
    }

    /**
     * 结束卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndStaffCard () {
        return self::getClass()->autoEndStaffCard();
    }

    /**
     * 过期卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireStaffCard () {
        return self::getClass()->expireStaffCard();
    }

    /**
     * 8点45计算小蜜蜂
     *
     * @param  int $year 年份 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function yearAward (int $year = NULL) {
        return self::getClass()->yearAward([
            "year" => $year,
        ]);
    }

    /**
     * 流水：隔日变当日
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStreamTakeTime () {
        return self::getClass()->updateStreamTakeTime();
    }

    /**
     * 根据更新时间,过去30分钟以上,
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindRetoucherOrgStream () {
        return self::getClass()->unbindRetoucherOrgStream();
    }

    /**
     * 冲量自动开始
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function impulseAutoUsing () {
        return self::getClass()->impulseAutoUsing();
    }

    /**
     * 生成第二日随机码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 每日22,0点记录队列余量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function logQueueInfo () {
        return self::getClass()->logQueueInfo();
    }

    /**
     * 8点半升级
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffLevelCheck () {
        return self::getClass()->staffLevelCheck();
    }

    /**
     * 30s检测无wsUserId则自动离线[强制离线]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoOffline () {
        return self::getClass()->autoOffline();
    }

    /**
     * 刷新组排名数据
     *
     * @param  string $cycle 周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoGroupRankFlushMonth (string $cycle = NULL) {
        return self::getClass()->autoGroupRankFlushMonth([
            "cycle" => $cycle,
        ]);
    }

    /**
     * 刷新个人排名数据
     *
     * @param  string $cycle 周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoStaffRankFlushMonth (string $cycle = NULL) {
        return self::getClass()->autoStaffRankFlushMonth([
            "cycle" => $cycle,
        ]);
    }

    /**
     * 刷新每日组排名数据
     *
     * @param  string $cycle 周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoGroupRankFlushDay (string $cycle = NULL) {
        return self::getClass()->autoGroupRankFlushDay([
            "cycle" => $cycle,
        ]);
    }

    /**
     * 自动将申诉过期
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoExpireStreamAppeal () {
        return self::getClass()->autoExpireStreamAppeal();
    }

    /**
     * 自动发送修图主管待初审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendRetoucherLeaderAppealExamine () {
        return self::getClass()->autoSendRetoucherLeaderAppealExamine();
    }

    /**
     * 自动发送待复审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendAppealManagerExamine () {
        return self::getClass()->autoSendAppealManagerExamine();
    }

    /**
     * 自动同步钉钉排班情况
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncStaffDaySchedule () {
        return self::getClass()->syncStaffDaySchedule();
    }

    /**
     * 自动初始化每日日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initDayAlarmLog () {
        return self::getClass()->initDayAlarmLog();
    }

    /**
     * 自动发送每日修图照片吞吐量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDayPhotoThroughputNotice () {
        return self::getClass()->sendDayPhotoThroughputNotice();
    }

    /**
     * 触发堆单检查
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoAlarmCheck () {
        return self::getClass()->photoAlarmCheck();
    }

    /**
     * 监控
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reportMonitor () {
        return self::getClass()->reportMonitor();
    }

    /**
     * 云端队列剩余单量 --- 早上八点
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueStreamStart () {
        return self::getClass()->queueStreamStart();
    }

    /**
     * 云端队列剩余单量 --- 晚上十点
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueStream () {
        return self::getClass()->queueStream();
    }

    /**
     * 绩效导入截止日期通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKpiSetMessage () {
        return self::getClass()->sendKpiSetMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}