<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method getListByParams(array $params)
 * @method getTreeByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增产品类别
     *
     * @support  string $name 产品类型名称 [ require true ]
     * @support  int $parentId 父级id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 编辑产品类别
     *
     * @support  string $name 产品类型名称 [ require true ]
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * 根据条件获取产品分类列表
     *
     * @support  array $conds 搜索条件 [ require true ]
     * @support  int $conds.parentIdEqual 搜索条件 - 父类id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 根据根节点id获取产品分类树
     *
     * @param  int $rootId 根分类节点id，获取整树所有则传0 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTree (int $rootId) {
        return self::getClass()->getTree([
            "rootId" => $rootId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}