<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 */
class ShowPicPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加修修兽抽片类别 ---v2.24
     *
     * @param  string $name 类别名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * 修改修修兽抽片类别 ---v2.24
     *
     * @param  int $id 类别id [ require true ]
     * @param  string $name 类别名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editScoreType (int $id, string $name) {
        return self::getClass()->editScoreType([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 获取修修兽抽片配置列表 ---v2.24
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreConfigList () {
        return self::getClass()->getScoreConfigList();
    }

    /**
     * 添加修修兽抽片评分配置---v2.24
     *
     * @param  string $name 评分项名称 [ require true ]
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * 修改修修兽抽片评分配置---v2.24
     *
     * @param  int $id 评分项id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "name" => $name,
            "children" => $children,
        ]);
    }

    /**
     * 删除修修兽抽片评分配置---v2.24
     *
     * @param  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'CheckPool\ShowPicPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'CheckPool\ShowPicPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}