<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method manualUpgradeStaffLevelByParams(array $params)
 * @method getQueueLengthByParams(array $params)
 * @method rollBackOverTimeIncomeByParams(array $params)
 * @method rollBackIncomeByParams(array $params)
 * @method rollbackStaffDayNormalIncomeByParams(array $params)
 * @method setQuotaByParams(array $params)
 * @method clearFinishPhotoByParams(array $params)
 * @method fixXiuDataByParams(array $params)
 * @method fixReworkReplaceByParams(array $params)
 * @method clearRetoucherLeaderLittleBeeCacheByParams(array $params)
 * @method rePushReviewStreamQueueByParams(array $params)
 * @method addMongoDataByParams(array $params)
 * @method pushRetouchQueueByParams(array $params)
 * @method fix2QueueByParams(array $params)
 * @method pushReviewQueueByParams(array $params)
 * @method autoSendRetoucherLeaderAppealExamineByParams(array $params)
 * @method autoSendAppealManagerExamineByParams(array $params)
 * @method syncStaffTodayScheduleByParams(array $params)
 * @method initDayAlarmLogByParams(array $params)
 * @method sendDayPhotoThroughputNoticeByParams(array $params)
 * @method photoAlarmCheckByParams(array $params)
 */
class Temple {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 手动升级
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $staffData 员工信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function manualUpgradeStaffLevel (int $staffId, array $staffData) {
        return self::getClass()->manualUpgradeStaffLevel([
            "staffId" => $staffId,
            "staffData" => $staffData,
        ]);
    }

    /**
     * 【大数据使用】
     *
     * @param  string $queueName 队列名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueLength (string $queueName) {
        return self::getClass()->getQueueLength([
            "queueName" => $queueName,
        ]);
    }

    /**
     * 回滚超时订单收益
     *
     * @param  string $passAt 通过时间 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rollBackOverTimeIncome (string $streamNum, string $passAt = '') {
        return self::getClass()->rollBackOverTimeIncome([
            "streamNum" => $streamNum,
            "passAt" => $passAt,
        ]);
    }

    /**
     * 回滚超时订单收益
     *
     * @param  string $passAt 通过时间 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rollBackIncome (string $streamNum, string $passAt = '') {
        return self::getClass()->rollBackIncome([
            "streamNum" => $streamNum,
            "passAt" => $passAt,
        ]);
    }

    /**
     * 重算并回滚员工某日普通收益
     *
     * @param  int $staffId id [Original type uint] [ require true ]
     * @param  string $date 日期 format Ymd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rollbackStaffDayNormalIncome (int $staffId, string $date) {
        return self::getClass()->rollbackStaffDayNormalIncome([
            "staffId" => $staffId,
            "date" => $date,
        ]);
    }

    /**
     * 回滚门店退回相关
     *
     * @param  string $time 时间 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $object 对象 [ require true ]
     * @param  string $value 值 [ require true ]
     * @param  string $itemName 项名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setQuota (string $type, string $time, int $object, string $value, string $itemName) {
        return self::getClass()->setQuota([
            "type" => $type,
            "time" => $time,
            "object" => $object,
            "value" => $value,
            "itemName" => $itemName,
        ]);
    }

    /**
     * 清空流水－顾客满意片[test]
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearFinishPhoto (string $streamNum) {
        return self::getClass()->clearFinishPhoto([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 补发流水已完成事件
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixXiuData (string $streamNum) {
        return self::getClass()->fixXiuData([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 补发流水已完成事件
     *
     * @param  array $photoIds 退回新照片 [ require true ]
     * @param  int $newStreamId 退回新流水 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixReworkReplace (array $photoIds, int $newStreamId) {
        return self::getClass()->fixReworkReplace([
            "photoIds" => $photoIds,
            "newStreamId" => $newStreamId,
        ]);
    }

    /**
     * 清除修图主管小蜜蜂缓存
     *
     * @param  int $year 年份 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearRetoucherLeaderLittleBeeCache (int $year = NULL) {
        return self::getClass()->clearRetoucherLeaderLittleBeeCache([
            "year" => $year,
        ]);
    }

    /**
     * 重推审核队列[清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rePushReviewStreamQueue () {
        return self::getClass()->rePushReviewStreamQueue();
    }

    /**
     * 填充mongo
     *
     * @param  array $mongoData 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addMongoData (array $mongoData) {
        return self::getClass()->addMongoData([
            "mongoData" => $mongoData,
        ]);
    }

    /**
     * 重推接单队列[不清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushRetouchQueue () {
        return self::getClass()->pushRetouchQueue();
    }

    /**
     * 修复队列未清单问题
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fix2Queue () {
        return self::getClass()->fix2Queue();
    }

    /**
     * 重推审核队列[不清空原队列]
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushReviewQueue () {
        return self::getClass()->pushReviewQueue();
    }

    /**
     * 主动触发-自动发送修图主管待初审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendRetoucherLeaderAppealExamine () {
        return self::getClass()->autoSendRetoucherLeaderAppealExamine();
    }

    /**
     * 主动触发-自动发送修图主管待初审通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendAppealManagerExamine () {
        return self::getClass()->autoSendAppealManagerExamine();
    }

    /**
     * 初始化每日排班表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncStaffTodaySchedule () {
        return self::getClass()->syncStaffTodaySchedule();
    }

    /**
     * 初始化报警日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initDayAlarmLog () {
        return self::getClass()->initDayAlarmLog();
    }

    /**
     * 主动触发-自动发送预计修图量通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDayPhotoThroughputNotice () {
        return self::getClass()->sendDayPhotoThroughputNotice();
    }

    /**
     * 触发堆单检查
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoAlarmCheck () {
        return self::getClass()->photoAlarmCheck();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Temple');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Temple');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}