<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method autoEndImpulseByParams(array $params)
 * @method expireImpulseByParams(array $params)
 * @method autoEndStaffCardByParams(array $params)
 * @method expireStaffCardByParams(array $params)
 * @method YearAwardByParams(array $params)
 * @method updateStreamTakeTimeByParams(array $params)
 * @method UnbindRetoucherOrgStreamByParams(array $params)
 * @method pushToRetouchStreamQueueByParams(array $params)
 * @method pushToReviewStreamQueueByParams(array $params)
 * @method impulseAutoUsingByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method logQueueInfoByParams(array $params)
 * @method staffLevelUpByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动结束冲量buff
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndImpulse () {
        return self::getClass()->autoEndImpulse();
    }

    /**
     * 过期冲量奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireImpulse () {
        return self::getClass()->expireImpulse();
    }

    /**
     * 结束卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndStaffCard () {
        return self::getClass()->autoEndStaffCard();
    }

    /**
     * 过期卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireStaffCard () {
        return self::getClass()->expireStaffCard();
    }

    /**
     * 延后
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function YearAward () {
        return self::getClass()->YearAward();
    }

    /**
     * 流水：隔日变当日
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStreamTakeTime () {
        return self::getClass()->updateStreamTakeTime();
    }

    /**
     * 根据更新时间,过去30分钟以上,
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function UnbindRetoucherOrgStream () {
        return self::getClass()->UnbindRetoucherOrgStream();
    }

    /**
     * 定时加入审核队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushToRetouchStreamQueue () {
        return self::getClass()->pushToRetouchStreamQueue();
    }

    /**
     * 定时加入审核队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushToReviewStreamQueue () {
        return self::getClass()->pushToReviewStreamQueue();
    }

    /**
     * 冲量自动开始
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function impulseAutoUsing () {
        return self::getClass()->impulseAutoUsing();
    }

    /**
     * 生成第二日随机码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 每日0点记录队列余量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function logQueueInfo () {
        return self::getClass()->logQueueInfo();
    }

    /**
     * 员工升级
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffLevelUp () {
        return self::getClass()->staffLevelUp();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}