<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method batchGetStreamInfoByParams(array $params)
 * @method revokeStreamByParams(array $params)
 * @method evaluateStreamByParams(array $params)
 * @method outStreamWaitReviewByParams(array $params)
 * @method outStreamWaitReviewedByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建流水
     *
     * @support  string $orderNum 外部订单号 [ require true ]
     * @support  int $productId 拍摄产品云端产品id [ require true ]
     * @support  string $retouchClaim.eye 修片要求--眼睛 [ require true ]
     * @support  string $retouchClaim.face 修片要求--脸 [ require true ]
     * @support  bool $retouchClaim.pimples 修片要求--痘痘 [ require true ]
     * @support  string $takeTime 取片时间 
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $photographyNote 摄影备注 
     * @support  string $retouchNote 修片备注 [ require true ]
     * @support  bool $special 业务方权重 
     * @throws  \Exception
     * @return  string
     */
    public static function createStream () {
        return self::getClass()->createStream();
    }

    /**
     * 获取流水单详情
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @support  int $needPhoto 是否需要照片数据 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (string $streamNum) {
        return self::getClass()->getStreamInfo([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 批量获取流水单信息
     *
     * @param  array $streamNums 流水号 [ require true ]
     * @support  int $needPhoto 是否需要照片数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetStreamInfo (array $streamNums) {
        return self::getClass()->batchGetStreamInfo([
            "streamNums" => $streamNums,
        ]);
    }

    /**
     * 此处为假删除操作
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function revokeStream (string $streamNum) {
        return self::getClass()->revokeStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 门店评价流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @support  int $storeEvaluateStar 星级 [Original type uint] [ require true ]
     * @support  string $storeEvaluateReason 评语 
     * @support  string $watcherName 看片师姓名 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function evaluateStream (string $streamNum) {
        return self::getClass()->evaluateStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 监听外包审核状态-等待审核
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReview (string $streamId) {
        return self::getClass()->outStreamWaitReview([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 监听外包审核状态-审核中
     *
     * @param  string $streamId 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function outStreamWaitReviewed (string $streamId) {
        return self::getClass()->outStreamWaitReviewed([
            "streamId" => $streamId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}