<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductListByParams(array $params)
 * @method passProductByParams(array $params)
 * @method editProductByParams(array $params)
 * @method refuseProductByParams(array $params)
 * @method delProductByParams(array $params)
 * @method getProductInfoByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品列表
     *
     * @support  int $photographerOrgId 摄影机构 
     * @support  array $productId 产品id 
     * @support  string $state 状态 [ require true ]
     * @support  string $weightLevel 权重等级 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductList (int $page, int $pageSize = 10) {
        return self::getClass()->getProductList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 审核通过
     *
     * @param  int $productId 产品id [ require true ]
     * @support  string $retouchStandard 修片标准 [ require true ]
     * @support  string $weightLevel 权重等级 [ require true ]
     * @support  bool $needSplicing 是否拼接 [ require true ]
     * @support  bool $needHourglass 是否沙漏 [ require true ]
     * @support  bool $needTemplate 是否有模板照 [ require true ]
     * @support  array $normalIncomeConfig 普通收益 [ require true ]
     * @support  array $splicingIncomeConfig 拼接收益 [ require true ]
     * @support  array $seaGrassConfig 海草收益 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function passProduct (int $productId) {
        return self::getClass()->passProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 修改产品
     *
     * @param  int $productId 产品id [ require true ]
     * @support  string $retouchStandard 修片标准 [ require true ]
     * @support  string $weightLevel 权重等级 [ require true ]
     * @support  bool $needSplicing 是否拼接 [ require true ]
     * @support  bool $needHourglass 是否沙漏 [ require true ]
     * @support  bool $needTemplate 是否有模板照 [ require true ]
     * @support  array $normalIncomeConfig 普通收益 [ require true ]
     * @support  array $splicingIncomeConfig 拼接收益 [ require true ]
     * @support  array $seaGrassConfig 海草收益 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editProduct (int $productId) {
        return self::getClass()->editProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 审核拒绝
     *
     * @param  int $productId 产品id [ require true ]
     * @param  string $refuseReason 退回原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuseProduct (int $productId, string $refuseReason) {
        return self::getClass()->refuseProduct([
            "productId" => $productId,
            "refuseReason" => $refuseReason,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delProduct (int $productId) {
        return self::getClass()->delProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}