<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinReviewQueueByParams(array $params)
 * @method exitReviewQueueByParams(array $params)
 * @method getReviewQueueInfoByParams(array $params)
 * @method getTodayReviewQuotaByParams(array $params)
 * @method getReviewInfoByParams(array $params)
 * @method passStreamByParams(array $params)
 * @method refuseStreamByParams(array $params)
 */
class Reviewer {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 进入审核人队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinReviewQueue () {
        return self::getClass()->joinReviewQueue();
    }

    /**
     * 退出审核人队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitReviewQueue () {
        return self::getClass()->exitReviewQueue();
    }

    /**
     * 获取审核队列信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewQueueInfo () {
        return self::getClass()->getReviewQueueInfo();
    }

    /**
     * 获取今日审核工作统计
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayReviewQuota () {
        return self::getClass()->getTodayReviewQuota();
    }

    /**
     * 获取审核信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewInfo () {
        return self::getClass()->getReviewInfo();
    }

    /**
     * 审核通过
     *
     * @support  int $streamId 流水号 [Original type uint] [ require true ]
     * @support  array $photoData 照片数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function passStream () {
        return self::getClass()->passStream();
    }

    /**
     * 审核退单
     *
     * @support  int $streamId 流水号 [Original type uint] [ require true ]
     * @support  array $photoData 照片数据 
     * @support  array $reviewNote 审核备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuseStream () {
        return self::getClass()->refuseStream();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Reviewer');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Reviewer');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}