<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSignatureByParams(array $params)
 * @method getHostByParams(array $params)
 * @method createPhotoVersionByParams(array $params)
 */
class PhotoManager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云上传凭证
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSignature () {
        return self::getClass()->getSignature();
    }

    /**
     * 返回host
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * todo 有用到？
     *
     * @param  string $version 照片版本 [ require true ]
     * @param  string $path 照片路径 [ require true ]
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhotoVersion (string $version, string $path, int $photoId) {
        return self::getClass()->createPhotoVersion([
            "version" => $version,
            "path" => $path,
            "photoId" => $photoId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}