<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method streamMatchRetoucherByParams(array $params)
 * @method autoEndImpulseByParams(array $params)
 * @method expireImpulseByParams(array $params)
 * @method autoEndStaffCardByParams(array $params)
 * @method expireStaffCardByParams(array $params)
 * @method YearAwardByParams(array $params)
 * @method incrWeightByParams(array $params)
 * @method updateStreamTakeTimeByParams(array $params)
 * @method UnbindRetoucherOrgStreamByParams(array $params)
 * @method impulseAutoUsingByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 匹配一对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamMatchRetoucher () {
        return self::getClass()->streamMatchRetoucher();
    }

    /**
     * 自动结束冲量buff
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndImpulse () {
        return self::getClass()->autoEndImpulse();
    }

    /**
     * 过期冲量奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireImpulse () {
        return self::getClass()->expireImpulse();
    }

    /**
     * 结束卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndStaffCard () {
        return self::getClass()->autoEndStaffCard();
    }

    /**
     * 过期卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireStaffCard () {
        return self::getClass()->expireStaffCard();
    }

    /**
     * 年终奖(小蜜蜂)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function YearAward () {
        return self::getClass()->YearAward();
    }

    /**
     * todo 计划任务 每一小时增加队列订单权重
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function incrWeight () {
        return self::getClass()->incrWeight();
    }

    /**
     * todo 计划任务 每日更新【隔日】队列权重
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStreamTakeTime () {
        return self::getClass()->updateStreamTakeTime();
    }

    /**
     * todo 根据更新时间 过去30分钟以上 tag里没有接单人名 则自动释放掉重回队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function UnbindRetoucherOrgStream () {
        return self::getClass()->UnbindRetoucherOrgStream();
    }

    /**
     * todo 冲量自动开始
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function impulseAutoUsing () {
        return self::getClass()->impulseAutoUsing();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}