<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method disableProductByParams(array $params)
 * @method enableProductByParams(array $params)
 * @method getProductListByIdsByParams(array $params)
 * @method getProductInfoByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $retouchRequire 修片要求 [ require true ]
     * @support  array $simpleImages 样片地址 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * 禁用产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableProduct (int $productId) {
        return self::getClass()->disableProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 启用产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableProduct (int $productId) {
        return self::getClass()->enableProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 批量获取产品信息
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  int $photographerOrgId 摄影机构id [ require true ]
     * @support  string $token api_token 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListByIds (array $productIds, int $page, int $pageSize, int $photographerOrgId) {
        return self::getClass()->getProductListByIds([
            "productIds" => $productIds,
            "page" => $page,
            "pageSize" => $pageSize,
            "photographerOrgId" => $photographerOrgId,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}