<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductListByParams(array $params)
 * @method passProductByParams(array $params)
 * @method refuseProductByParams(array $params)
 * @method delProductByParams(array $params)
 * @method getProductInfoByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品列表
     *
     * @support  int $photographer_org_id 摄影机构 
     * @support  string $name 产品名称 
     * @support  string $state 状态 [ require true ]
     * @support  string $weight_level 权重等级 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductList (int $page, int $page_size) {
        return self::getClass()->getProductList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 审核通过
     *
     * @param  int $product_id 产品id [ require true ]
     * @support  string $retouch_standard 修片标准 [ require true ]
     * @support  string $weight_level 权重等级 [ require true ]
     * @support  bool $need_splicing 是否拼接 [ require true ]
     * @support  bool $need_hourglass 是否沙漏 [ require true ]
     * @support  bool $need_template 是否有模板照 [ require true ]
     * @support  array $normal_income_config 普通收益 [ require true ]
     * @support  array $splicing_income_config 拼接收益 [ require true ]
     * @support  array $sea_grass_config 海草收益 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function passProduct (int $product_id) {
        return self::getClass()->passProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 审核拒绝
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  string $refuse_reason 退回原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuseProduct (int $product_id, string $refuse_reason) {
        return self::getClass()->refuseProduct([
            "product_id" => $product_id,
            "refuse_reason" => $refuse_reason,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delProduct (int $product_id) {
        return self::getClass()->delProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}