<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoListByParams(array $params)
 * @method getPhotoInfoByParams(array $params)
 * @method submitAttitudeByParams(array $params)
 * @method getAttitudePhotoInfoByParams(array $params)
 * @method getAttitudePhotoListByParams(array $params)
 */
class PhotoTool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取客片列表
     *
     * @support  string $start_at 开始时间 [ require true ]
     * @support  string $end_at 结束时间 [ require true ]
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @support  string $stream_num 云图流水号 
     * @support  string $customer_name 顾客姓名 
     * @support  string $telephone 手机号 
     * @support  int $evaluate_star 评价星级 [Original type uint] 
     * @support  int $page 页面 [Original type uint] 
     * @support  int $page_size 每页数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoList () {
        return self::getClass()->getPhotoList();
    }

    /**
     * 获取客片详情
     *
     * @support  int $photo_uuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoInfo () {
        return self::getClass()->getPhotoInfo();
    }

    /**
     * 提交【踩/赞】
     *
     * @support  int $photo_version_id 图片版本id [ require true ]
     * @support  string $attitude 态度【赞，踩】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitAttitude () {
        return self::getClass()->submitAttitude();
    }

    /**
     * 获取赞或踩客片详情
     *
     * @support  int $photo_uuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAttitudePhotoInfo () {
        return self::getClass()->getAttitudePhotoInfo();
    }

    /**
     * 获取优秀/问题客片列表
     *
     * @support  string $attitude 态度【赞，踩】 [ require true ]
     * @support  string $start_at 开始时间 [ require true ]
     * @support  string $end_at 结束时间 [ require true ]
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @support  int $page 页面 [Original type uint] 
     * @support  int $page_size 每页数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getAttitudePhotoList () {
        return self::getClass()->getAttitudePhotoList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoTool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoTool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}