<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method urgentOrderByParams(array $params)
 * @method urgentStreamByParams(array $params)
 * @method getRetouchStreamListByParams(array $params)
 * @method getReviewStreamListByParams(array $params)
 * @method getStreamListByParams(array $params)
 * @method getFlowInfoByParams(array $params)
 * @method getCloudRetoucherQuotaByParams(array $params)
 * @method editRetoucherGroupTargetQuotaByParams(array $params)
 * @method getRetoucherQuotaByParams(array $params)
 * @method getWholeQuotaByParams(array $params)
 * @method getReviewQuotaByParams(array $params)
 * @method getStreamTimesQuotaByParams(array $params)
 * @method getStoreEvaluateByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method modifyStreamByParams(array $params)
 * @method addRetouchOrgByParams(array $params)
 * @method enableRetouchOrgByParams(array $params)
 * @method disableRetouchOrgByParams(array $params)
 * @method editRetouchOrgByParams(array $params)
 * @method getRetouchOrgInfoByParams(array $params)
 * @method getRetouchOrgListByParams(array $params)
 * @method addPhotographerOrgByParams(array $params)
 * @method editPhotographerOrgByParams(array $params)
 * @method getPhotographerOrgListByParams(array $params)
 * @method enablePhotographerOrgByParams(array $params)
 * @method disablePhotographerOrgByParams(array $params)
 * @method getPhotographerOrgInfoByParams(array $params)
 */
class Operator {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 加急订单
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentOrder (int $order_id) {
        return self::getClass()->urgentOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 加急流水
     *
     * @param  int $stream_id 流水id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentStream (int $stream_id) {
        return self::getClass()->urgentStream([
            "stream_id" => $stream_id,
        ]);
    }

    /**
     * 获取修片流水列表
     *
     * @support  string $retoucher_standard 修图标准 
     * @support  string $stream_state 流水状态 
     * @support  int $page page [Original type uint] 
     * @support  int $page_size page_size [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchStreamList () {
        return self::getClass()->getRetouchStreamList();
    }

    /**
     * 获取审核流水列表
     *
     * @support  string $retoucher_standard 修图标准 
     * @support  string $stream_state 流水状态 
     * @support  int $page page [Original type uint] 
     * @support  int $page_size page_size [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewStreamList () {
        return self::getClass()->getReviewStreamList();
    }

    /**
     * 获取流水列表
     *
     * @support  string $customer_name 顾客姓名 
     * @support  string $order_num 订单号【外部订单号】 
     * @support  string $stream_num 流水号 
     * @support  int $page page [Original type uint] 
     * @support  int $page_size page_size [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamList () {
        return self::getClass()->getStreamList();
    }

    /**
     * 获取流水看板数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getFlowInfo () {
        return self::getClass()->getFlowInfo();
    }

    /**
     * 获取云端工作指标
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudRetoucherQuota () {
        return self::getClass()->getCloudRetoucherQuota();
    }

    /**
     * 编辑修图组目标指标
     *
     * @support  int $expect_photo_num 预计完成照片数 [Original type uint] [ require true ]
     * @support  int $group_id 修图组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetoucherGroupTargetQuota () {
        return self::getClass()->editRetoucherGroupTargetQuota();
    }

    /**
     * 获取伙伴绩效
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherQuota () {
        return self::getClass()->getRetoucherQuota();
    }

    /**
     * 获取总体绩效
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getWholeQuota () {
        return self::getClass()->getWholeQuota();
    }

    /**
     * 获取审核绩效[审与被审]
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $review_id 审核人id [Original type uint] 
     * @support  int $group_id 修图id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewQuota () {
        return self::getClass()->getReviewQuota();
    }

    /**
     * 获取流水时间指标
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $retouch_group 修片组别id 
     * @support  int $retouch_class 修图类别id 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamTimesQuota () {
        return self::getClass()->getStreamTimesQuota();
    }

    /**
     * 获取门店评价
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  int $staff_id 伙伴id 
     * @support  int $star 评分星级 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreEvaluate () {
        return self::getClass()->getStoreEvaluate();
    }

    /**
     * 获取流水信息【只能查到未审核通过流水】
     *
     * @support  int $order_id 订单号 
     * @support  string $stream_num 流水号 
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo () {
        return self::getClass()->getStreamInfo();
    }

    /**
     * 更改流水信息【只能修改未审核通过流水】
     *
     * @support  array $photos 修改照片数据 [ require true ]
     * @support  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyStream () {
        return self::getClass()->modifyStream();
    }

    /**
     * 添加修图机构
     *
     * @support  string $name 机构名 [ require true ]
     * @support  string $code 机构代号 [ require true ]
     * @support  string $account 机构主账号 [ require true ]
     * @support  string $secret 机构密码 
     * @support  array $enable_product_ids 可接产品 [ require true ]
     * @support  array $income_config 收益配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRetouchOrg () {
        return self::getClass()->addRetouchOrg();
    }

    /**
     * 启动修图机构
     *
     * @param  int $retouch_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableRetouchOrg (int $retouch_org_id) {
        return self::getClass()->enableRetouchOrg([
            "retouch_org_id" => $retouch_org_id,
        ]);
    }

    /**
     * 禁用修图机构
     *
     * @param  int $retouch_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableRetouchOrg (int $retouch_org_id) {
        return self::getClass()->disableRetouchOrg([
            "retouch_org_id" => $retouch_org_id,
        ]);
    }

    /**
     * 修改修图机构
     *
     * @param  bool $retouch_org_id 机构名 [ require true ]
     * @support  string $name 机构名 [ require true ]
     * @support  string $code 机构代号 [ require true ]
     * @support  string $account 机构主账号 [ require true ]
     * @support  string $secret 机构密码 
     * @support  array $enable_product_ids 可接产品 [ require true ]
     * @support  array $income_config 收益配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetouchOrg (bool $retouch_org_id) {
        return self::getClass()->editRetouchOrg([
            "retouch_org_id" => $retouch_org_id,
        ]);
    }

    /**
     * 获取修图机构信息
     *
     * @param  bool $retouch_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgInfo (bool $retouch_org_id) {
        return self::getClass()->getRetouchOrgInfo([
            "retouch_org_id" => $retouch_org_id,
        ]);
    }

    /**
     * 获取修图机构列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgList () {
        return self::getClass()->getRetouchOrgList();
    }

    /**
     * 添加摄影机构
     *
     * @support  string $name 机构名 [ require true ]
     * @support  string $account 机构主账号 
     * @support  string $secret 机构密码 
     * @support  string $type 登录方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotographerOrg () {
        return self::getClass()->addPhotographerOrg();
    }

    /**
     * 修改摄影机构
     *
     * @param  int $photographer_org_id 机构id [ require true ]
     * @support  string $name 机构名 [ require true ]
     * @support  string $account 机构主账号 
     * @support  string $secret 机构密码 
     * @support  string $state 机构状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editPhotographerOrg (int $photographer_org_id) {
        return self::getClass()->editPhotographerOrg([
            "photographer_org_id" => $photographer_org_id,
        ]);
    }

    /**
     * 获取摄影机构列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographerOrgList () {
        return self::getClass()->getPhotographerOrgList();
    }

    /**
     * 启动摄影机构
     *
     * @param  int $photographer_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enablePhotographerOrg (int $photographer_org_id) {
        return self::getClass()->enablePhotographerOrg([
            "photographer_org_id" => $photographer_org_id,
        ]);
    }

    /**
     * 禁用摄影机构
     *
     * @param  int $photographer_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disablePhotographerOrg (int $photographer_org_id) {
        return self::getClass()->disablePhotographerOrg([
            "photographer_org_id" => $photographer_org_id,
        ]);
    }

    /**
     * 获取摄影机构信息
     *
     * @param  int $photographer_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographerOrgInfo (int $photographer_org_id) {
        return self::getClass()->getPhotographerOrgInfo([
            "photographer_org_id" => $photographer_org_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Operator');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Operator');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}